/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.internal.fasta.qual;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;
import org.jcvi.jillion.core.datastore.DataStore;
import org.jcvi.jillion.core.qual.PhredQuality;
import org.jcvi.jillion.core.qual.QualitySequence;
import org.jcvi.jillion.core.qual.QualitySequenceDataStore;
import org.jcvi.jillion.core.util.Builder;
import org.jcvi.jillion.fasta.FastaRecord;
import org.jcvi.jillion.fasta.FastaRecordVisitor;
import org.jcvi.jillion.fasta.FastaVisitor;
import org.jcvi.jillion.fasta.FastaVisitorCallback;
import org.jcvi.jillion.fasta.qual.AbstractQualityFastaRecordVisitor;
import org.jcvi.jillion.fasta.qual.QualityFastaDataStore;
import org.jcvi.jillion.fasta.qual.QualityFastaRecord;
import org.jcvi.jillion.internal.fasta.AdaptedFastaDataStore;

public class DefaultQualityFastaFileDataStoreBuilder
implements FastaVisitor,
Builder<QualityFastaDataStore> {
    private final Map<String, QualityFastaRecord> fastaRecords = new LinkedHashMap<String, QualityFastaRecord>();
    private final Predicate<String> filter;
    private final Predicate<QualityFastaRecord> recordFilter;

    public DefaultQualityFastaFileDataStoreBuilder(Predicate<String> filter, Predicate<QualityFastaRecord> recordFilter) {
        this.filter = filter;
        this.recordFilter = recordFilter;
    }

    @Override
    public FastaRecordVisitor visitDefline(FastaVisitorCallback callback, final String id, String optionalComment) {
        if (!this.filter.test(id)) {
            return null;
        }
        return new AbstractQualityFastaRecordVisitor(id, optionalComment){

            @Override
            protected void visitRecord(QualityFastaRecord fastaRecord) {
                if (DefaultQualityFastaFileDataStoreBuilder.this.recordFilter == null || DefaultQualityFastaFileDataStoreBuilder.this.recordFilter.test(fastaRecord)) {
                    DefaultQualityFastaFileDataStoreBuilder.this.fastaRecords.put(id, fastaRecord);
                }
            }
        };
    }

    @Override
    public void visitEnd() {
    }

    @Override
    public void halted() {
    }

    @Override
    public QualityFastaDataStore build() {
        return new AdaptedQualityDataStore(this.fastaRecords);
    }

    private static final class AdaptedQualityDataStore
    extends AdaptedFastaDataStore<PhredQuality, QualitySequence, QualityFastaRecord, QualitySequenceDataStore>
    implements QualityFastaDataStore {
        public AdaptedQualityDataStore(Map<String, QualityFastaRecord> map) {
            super(map);
        }

        @Override
        public QualitySequenceDataStore asSequenceDataStore() {
            return DataStore.adapt(QualitySequenceDataStore.class, this, FastaRecord::getSequence);
        }
    }
}

