/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.internal.fasta.aa;

import java.util.regex.Pattern;
import org.jcvi.jillion.core.residue.aa.ProteinSequence;
import org.jcvi.jillion.core.util.ObjectsUtil;
import org.jcvi.jillion.fasta.aa.ProteinFastaRecord;
import org.jcvi.jillion.internal.fasta.FastaUtil;

public class UnCommentedProteinFastaRecord
implements ProteinFastaRecord {
    private static final int NUMBER_OF_BASES_PER_LINE = 60;
    private static final Pattern LINE_SPLITTER_PATTERN = Pattern.compile(String.format("(.{%s})", 60));
    private static final String LINE_SPLITTER_REPLACEMENT = "$1" + FastaUtil.getLineSeparator();
    private final ProteinSequence sequence;
    private final String id;

    public UnCommentedProteinFastaRecord(String id, ProteinSequence sequence) {
        if (id == null) {
            throw new NullPointerException("identifier can not be null");
        }
        if (sequence == null) {
            throw new NullPointerException("sequence can not be null");
        }
        this.id = id;
        this.sequence = sequence;
    }

    @Override
    public final String getId() {
        return this.id;
    }

    @Override
    public String getComment() {
        return null;
    }

    @Override
    public final ProteinSequence getSequence() {
        return this.sequence;
    }

    private final String toFormattedString() {
        int bufferSize = this.computeFormattedBufferSize();
        StringBuilder record = new StringBuilder(bufferSize);
        record.append(FastaUtil.getHeaderPrefix()).append(this.getId());
        if (this.getComment() != null) {
            record.append(' ').append(this.getComment());
        }
        record.append(FastaUtil.getLineSeparator()).append(this.getRecordBody()).append(FastaUtil.getLineSeparator());
        return record.toString();
    }

    private int computeFormattedBufferSize() {
        int size = 2 + this.id.length();
        if (this.getComment() != null) {
            size += 1 + this.getComment().length();
        }
        int seqLength = (int)this.sequence.getLength();
        int numberOfLines = seqLength / 60 + 1;
        return size + seqLength + numberOfLines;
    }

    public final String toString() {
        return this.toFormattedString();
    }

    private String getRecordBody() {
        String result = LINE_SPLITTER_PATTERN.matcher(this.sequence.toString()).replaceAll(LINE_SPLITTER_REPLACEMENT);
        long length = this.sequence.getLength();
        if (length > 0L && length % 60L == 0L) {
            return result.substring(0, result.length() - 1);
        }
        return result;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id.hashCode();
        result = 31 * result + this.getSequence().hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ProteinFastaRecord)) {
            return false;
        }
        ProteinFastaRecord other = (ProteinFastaRecord)obj;
        return ObjectsUtil.nullSafeEquals(this.getSequence(), other.getSequence()) && ObjectsUtil.nullSafeEquals(this.getId(), other.getId());
    }
}

