/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.internal.fasta.aa;

import java.io.IOException;
import java.util.function.Predicate;
import org.jcvi.jillion.core.datastore.DataStoreFilters;
import org.jcvi.jillion.fasta.FastaParser;
import org.jcvi.jillion.fasta.FastaRecordVisitor;
import org.jcvi.jillion.fasta.FastaVisitor;
import org.jcvi.jillion.fasta.FastaVisitorCallback;
import org.jcvi.jillion.fasta.aa.AbstractProteinFastaRecordVisitor;
import org.jcvi.jillion.fasta.aa.ProteinFastaRecord;
import org.jcvi.jillion.internal.core.util.iter.AbstractBlockingStreamingIterator;

final class LargeProteinFastaIterator
extends AbstractBlockingStreamingIterator<ProteinFastaRecord> {
    private final FastaParser parser;
    private final Predicate<String> filter;
    private final Predicate<ProteinFastaRecord> recordFilter;

    public static LargeProteinFastaIterator createNewIteratorFor(FastaParser parser) {
        return LargeProteinFastaIterator.createNewIteratorFor(parser, DataStoreFilters.alwaysAccept(), null);
    }

    public static LargeProteinFastaIterator createNewIteratorFor(FastaParser parser, Predicate<String> filter, Predicate<ProteinFastaRecord> recordFilter) {
        LargeProteinFastaIterator iter = new LargeProteinFastaIterator(parser, filter, recordFilter);
        iter.start();
        return iter;
    }

    private LargeProteinFastaIterator(FastaParser parser, Predicate<String> filter, Predicate<ProteinFastaRecord> recordFilter) {
        this.parser = parser;
        this.filter = filter;
        this.recordFilter = recordFilter;
    }

    @Override
    protected void backgroundThreadRunMethod() {
        FastaVisitor visitor = new FastaVisitor(){

            @Override
            public FastaRecordVisitor visitDefline(final FastaVisitorCallback callback, String id, String optionalComment) {
                if (!LargeProteinFastaIterator.this.filter.test(id)) {
                    return null;
                }
                return new AbstractProteinFastaRecordVisitor(id, optionalComment){

                    @Override
                    protected void visitRecord(ProteinFastaRecord fastaRecord) {
                        if (LargeProteinFastaIterator.this.recordFilter == null || LargeProteinFastaIterator.this.recordFilter.test(fastaRecord)) {
                            LargeProteinFastaIterator.this.blockingPut(fastaRecord);
                            if (LargeProteinFastaIterator.this.isClosed()) {
                                callback.haltParsing();
                            }
                        }
                    }
                };
            }

            @Override
            public void visitEnd() {
            }

            @Override
            public void halted() {
            }
        };
        try {
            this.parser.parse(visitor);
        }
        catch (IOException e) {
            throw new RuntimeException("can not parse fasta file", e);
        }
    }
}

