/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.internal.fasta.aa;

import java.io.File;
import java.io.IOException;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jcvi.jillion.core.datastore.DataStoreFilters;
import org.jcvi.jillion.core.residue.aa.AminoAcid;
import org.jcvi.jillion.core.residue.aa.ProteinSequence;
import org.jcvi.jillion.core.residue.aa.ProteinSequenceDataStore;
import org.jcvi.jillion.core.util.iter.StreamingIterator;
import org.jcvi.jillion.fasta.FastaFileParser;
import org.jcvi.jillion.fasta.FastaParser;
import org.jcvi.jillion.fasta.FastaRecordVisitor;
import org.jcvi.jillion.fasta.aa.AbstractProteinFastaRecordVisitor;
import org.jcvi.jillion.fasta.aa.ProteinFastaDataStore;
import org.jcvi.jillion.fasta.aa.ProteinFastaFileDataStore;
import org.jcvi.jillion.fasta.aa.ProteinFastaRecord;
import org.jcvi.jillion.internal.core.datastore.DataStoreStreamingIterator;
import org.jcvi.jillion.internal.fasta.AbstractLargeFastaFileDataStore;
import org.jcvi.jillion.internal.fasta.aa.LargeProteinFastaIterator;

public final class LargeProteinFastaFileDataStore
extends AbstractLargeFastaFileDataStore<AminoAcid, ProteinSequence, ProteinFastaRecord, ProteinSequenceDataStore>
implements ProteinFastaFileDataStore {
    public static ProteinFastaDataStore create(File fastaFile) throws IOException {
        return LargeProteinFastaFileDataStore.create(fastaFile, (Predicate<String>)DataStoreFilters.alwaysAccept(), null);
    }

    public static ProteinFastaDataStore create(File fastaFile, Predicate<String> filter, Predicate<ProteinFastaRecord> recordFilter) throws IOException {
        FastaParser parser = FastaFileParser.create(fastaFile);
        return new LargeProteinFastaFileDataStore(parser, filter, recordFilter);
    }

    public static ProteinFastaFileDataStore create(FastaParser parser) {
        return LargeProteinFastaFileDataStore.create(parser, (Predicate<String>)DataStoreFilters.alwaysAccept(), null);
    }

    public static ProteinFastaFileDataStore create(FastaParser parser, Predicate<String> filter, Predicate<ProteinFastaRecord> recordFilter) {
        return new LargeProteinFastaFileDataStore(parser, filter, recordFilter);
    }

    protected LargeProteinFastaFileDataStore(FastaParser parser, Predicate<String> filter, Predicate<ProteinFastaRecord> recordFilter) {
        super(parser, filter, recordFilter);
    }

    @Override
    protected StreamingIterator<ProteinFastaRecord> createNewIterator(FastaParser parser, Predicate<String> filter, Predicate<ProteinFastaRecord> recordFilter) {
        return DataStoreStreamingIterator.create(this, LargeProteinFastaIterator.createNewIteratorFor(parser, filter, recordFilter));
    }

    @Override
    protected FastaRecordVisitor createRecordVisitor(String id, String comment, final Consumer<ProteinFastaRecord> callback) {
        return new AbstractProteinFastaRecordVisitor(id, comment){

            @Override
            protected void visitRecord(ProteinFastaRecord fastaRecord) {
                callback.accept(fastaRecord);
            }
        };
    }
}

