/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.internal.fasta.aa;

import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;
import org.jcvi.jillion.core.datastore.DataStoreClosedException;
import org.jcvi.jillion.core.datastore.DataStoreEntry;
import org.jcvi.jillion.core.datastore.DataStoreException;
import org.jcvi.jillion.core.datastore.DataStoreFilters;
import org.jcvi.jillion.core.util.Builder;
import org.jcvi.jillion.core.util.iter.StreamingIterator;
import org.jcvi.jillion.fasta.FastaFileParser;
import org.jcvi.jillion.fasta.FastaParser;
import org.jcvi.jillion.fasta.FastaRecordVisitor;
import org.jcvi.jillion.fasta.FastaVisitor;
import org.jcvi.jillion.fasta.FastaVisitorCallback;
import org.jcvi.jillion.fasta.aa.AbstractProteinFastaRecordVisitor;
import org.jcvi.jillion.fasta.aa.ProteinFastaFileDataStore;
import org.jcvi.jillion.fasta.aa.ProteinFastaRecord;
import org.jcvi.jillion.internal.core.datastore.DataStoreStreamingIterator;
import org.jcvi.jillion.internal.fasta.aa.LargeProteinFastaIterator;

public final class IndexedProteinFastaFileDataStore {
    private IndexedProteinFastaFileDataStore() {
    }

    public static ProteinFastaFileDataStore create(File fastaFile) throws IOException {
        return IndexedProteinFastaFileDataStore.create(fastaFile, (Predicate<String>)DataStoreFilters.alwaysAccept(), null);
    }

    public static ProteinFastaFileDataStore create(File fastaFile, Predicate<String> filter, Predicate<ProteinFastaRecord> recordFilter) throws IOException {
        FastaParser parser = FastaFileParser.create(fastaFile);
        return IndexedProteinFastaFileDataStore.create(parser, filter, recordFilter);
    }

    public static ProteinFastaFileDataStore create(FastaParser parser, Predicate<String> filter, Predicate<ProteinFastaRecord> recordFilter) throws IOException {
        IndexedProteinFastaDataStoreBuilderVisitor builder = new IndexedProteinFastaDataStoreBuilderVisitor(parser, filter, recordFilter);
        builder.initialize();
        return builder.build();
    }

    private static class SingleRecordVisitor
    implements FastaVisitor {
        private ProteinFastaRecord fastaRecord = null;

        private SingleRecordVisitor() {
        }

        @Override
        public FastaRecordVisitor visitDefline(FastaVisitorCallback callback, String id, String optionalComment) {
            if (this.fastaRecord != null) {
                callback.haltParsing();
                return null;
            }
            return new AbstractProteinFastaRecordVisitor(id, optionalComment){

                @Override
                protected void visitRecord(ProteinFastaRecord fastaRecord) {
                    fastaRecord = fastaRecord;
                }
            };
        }

        @Override
        public void visitEnd() {
        }

        @Override
        public void halted() {
        }
    }

    public static final class Impl
    implements ProteinFastaFileDataStore {
        private volatile boolean closed = false;
        private final FastaParser parser;
        private final Predicate<String> filter;
        private final Predicate<ProteinFastaRecord> recordFilter;
        private final Map<String, FastaVisitorCallback.FastaVisitorMemento> mementos;

        public Impl(FastaParser parser, Predicate<String> filter, Predicate<ProteinFastaRecord> recordFilter, Map<String, FastaVisitorCallback.FastaVisitorMemento> mementos) {
            this.parser = parser;
            this.mementos = mementos;
            this.filter = filter;
            this.recordFilter = recordFilter;
        }

        @Override
        public StreamingIterator<String> idIterator() throws DataStoreException {
            this.throwExceptionIfClosed();
            return DataStoreStreamingIterator.create(this, this.mementos.keySet().iterator());
        }

        @Override
        public ProteinFastaRecord get(String id) throws DataStoreException {
            this.throwExceptionIfClosed();
            if (!this.mementos.containsKey(id)) {
                return null;
            }
            SingleRecordVisitor visitor = new SingleRecordVisitor();
            try {
                this.parser.parse(visitor, this.mementos.get(id));
                return visitor.fastaRecord;
            }
            catch (IOException e) {
                throw new DataStoreException("error reading fasta file", e);
            }
        }

        @Override
        public StreamingIterator<ProteinFastaRecord> iterator() throws DataStoreException {
            this.throwExceptionIfClosed();
            return DataStoreStreamingIterator.create(this, LargeProteinFastaIterator.createNewIteratorFor(this.parser, this.filter, this.recordFilter));
        }

        @Override
        public StreamingIterator<DataStoreEntry<ProteinFastaRecord>> entryIterator() throws DataStoreException {
            this.throwExceptionIfClosed();
            StreamingIterator<DataStoreEntry<ProteinFastaRecord>> entryIter = new StreamingIterator<DataStoreEntry<ProteinFastaRecord>>(){
                StreamingIterator<ProteinFastaRecord> iter;
                {
                    this.iter = LargeProteinFastaIterator.createNewIteratorFor(parser, filter, recordFilter);
                }

                @Override
                public boolean hasNext() {
                    return this.iter.hasNext();
                }

                @Override
                public void close() {
                    this.iter.close();
                }

                @Override
                public DataStoreEntry<ProteinFastaRecord> next() {
                    ProteinFastaRecord next = this.iter.next();
                    return new DataStoreEntry<ProteinFastaRecord>(next.getId(), next);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
            return DataStoreStreamingIterator.create(this, entryIter);
        }

        private void throwExceptionIfClosed() throws DataStoreException {
            if (this.closed) {
                throw new DataStoreClosedException("datastore is closed");
            }
        }

        @Override
        public boolean contains(String id) throws DataStoreException {
            this.throwExceptionIfClosed();
            return this.mementos.containsKey(id);
        }

        @Override
        public long getNumberOfRecords() throws DataStoreException {
            this.throwExceptionIfClosed();
            return this.mementos.size();
        }

        @Override
        public boolean isClosed() {
            return this.closed;
        }

        @Override
        public void close() {
            this.closed = true;
        }
    }

    private static final class IndexedProteinFastaDataStoreBuilderVisitor
    implements FastaVisitor,
    Builder<ProteinFastaFileDataStore> {
        private final Predicate<String> filter;
        private final Predicate<ProteinFastaRecord> recordFilter;
        private final FastaParser parser;
        private final Map<String, FastaVisitorCallback.FastaVisitorMemento> mementos = new LinkedHashMap<String, FastaVisitorCallback.FastaVisitorMemento>();

        private IndexedProteinFastaDataStoreBuilderVisitor(FastaParser parser, Predicate<String> filter, Predicate<ProteinFastaRecord> recordFilter) throws IOException {
            this.filter = filter;
            this.parser = parser;
            this.recordFilter = recordFilter;
        }

        public void initialize() throws IOException {
            this.parser.parse(this);
        }

        @Override
        public FastaRecordVisitor visitDefline(FastaVisitorCallback callback, final String id, String optionalComment) {
            if (this.filter.test(id)) {
                if (!callback.canCreateMemento()) {
                    throw new IllegalStateException("must be able to create memento");
                }
                final FastaVisitorCallback.FastaVisitorMemento memento = callback.createMemento();
                if (this.recordFilter == null) {
                    this.mementos.put(id, memento);
                } else {
                    return new AbstractProteinFastaRecordVisitor(id, optionalComment){

                        @Override
                        protected void visitRecord(ProteinFastaRecord fastaRecord) {
                            if (recordFilter.test(fastaRecord)) {
                                mementos.put(id, memento);
                            }
                        }
                    };
                }
            }
            return null;
        }

        @Override
        public void visitEnd() {
        }

        @Override
        public void halted() {
        }

        @Override
        public ProteinFastaFileDataStore build() {
            return new Impl(this.parser, this.filter, this.recordFilter, this.mementos);
        }
    }
}

