/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.internal.fasta;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.jcvi.jillion.core.Sequence;
import org.jcvi.jillion.core.datastore.DataStoreException;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.util.iter.IteratorUtil;
import org.jcvi.jillion.core.util.iter.StreamingIterator;
import org.jcvi.jillion.fasta.FastaRecord;
import org.jcvi.jillion.fasta.FastaWriter;
import org.jcvi.jillion.internal.core.util.iter.MergedSortedRecordIterator;

public abstract class TmpDirSortedFastaWriter<S, T extends Sequence<S>, F extends FastaRecord<S, T>>
implements FastaWriter<S, T, F> {
    private final File tmpDir;
    private final List<File> tmpFiles = new ArrayList<File>();
    private final int cacheSize;
    private final Comparator<F> comparator;
    private final Set<F> cache;
    private final FastaWriter<S, T, F> finalWriter;
    private volatile boolean isClosed;

    public TmpDirSortedFastaWriter(FastaWriter<S, T, F> finalWriter, Comparator<F> comparator, File tmpDir, int cacheSize) {
        this.tmpDir = tmpDir;
        this.cacheSize = cacheSize;
        this.comparator = comparator;
        this.cache = new TreeSet<F>(comparator);
        this.finalWriter = finalWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws IOException {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        ArrayList<StreamingIterator<F>> iters = new ArrayList<StreamingIterator<F>>();
        try {
            iters.add(IteratorUtil.createPeekableStreamingIterator(this.cache.iterator()));
            for (File file : this.tmpFiles) {
                try {
                    iters.add(this.createStreamingIteratorFor(file));
                }
                catch (DataStoreException e) {
                    throw new IOException("error re-parsing temp file " + file.getAbsolutePath(), e);
                }
            }
            MergedSortedRecordIterator<F> mergedIter = new MergedSortedRecordIterator<F>(iters, this.comparator);
            try {
                while (mergedIter.hasNext()) {
                    this.finalWriter.write((FastaRecord)mergedIter.next());
                }
            }
            finally {
                this.finalWriter.close();
            }
        }
        catch (Throwable throwable) {
            for (StreamingIterator streamingIterator : iters) {
                IOUtil.closeAndIgnoreErrors((Closeable)streamingIterator);
            }
            this.cache.clear();
            for (File file : this.tmpFiles) {
                IOUtil.deleteIgnoreError(file);
            }
            this.tmpFiles.clear();
            throw throwable;
        }
        for (StreamingIterator streamingIterator : iters) {
            IOUtil.closeAndIgnoreErrors((Closeable)streamingIterator);
        }
        this.cache.clear();
        for (File file : this.tmpFiles) {
            IOUtil.deleteIgnoreError(file);
        }
        this.tmpFiles.clear();
    }

    private synchronized void writeToCache(F record) throws IOException {
        this.cache.add(record);
        if (this.cache.size() >= this.cacheSize) {
            this.writeCacheToTmpFile();
            this.cache.clear();
        }
    }

    protected abstract StreamingIterator<F> createStreamingIteratorFor(File var1) throws IOException, DataStoreException;

    protected abstract FastaWriter<S, T, F> createNewTmpWriter(File var1) throws IOException;

    protected abstract F createFastaRecord(String var1, T var2, String var3);

    private void writeCacheToTmpFile() throws IOException {
        File tmpFile = File.createTempFile("sorted.", ".fastq", this.tmpDir);
        try (FastaWriter<S, T, FastaRecord> writer = this.createNewTmpWriter(tmpFile);){
            for (FastaRecord record : this.cache) {
                writer.write(record);
            }
        }
        this.tmpFiles.add(tmpFile);
    }

    @Override
    public void write(F record) throws IOException {
        if (this.isClosed) {
            throw new IOException("writer is closed");
        }
        Objects.requireNonNull(record);
        this.writeToCache(record);
    }

    @Override
    public void write(String id, T sequence) throws IOException {
        this.write(id, sequence, null);
    }

    @Override
    public void write(String id, T sequence, String optionalComment) throws IOException {
        this.write(this.createFastaRecord(id, sequence, optionalComment));
    }
}

