/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.internal.fasta;

import java.io.IOException;
import java.util.function.Predicate;
import org.jcvi.jillion.core.datastore.DataStoreFilters;
import org.jcvi.jillion.fasta.FastaParser;
import org.jcvi.jillion.fasta.FastaRecordVisitor;
import org.jcvi.jillion.fasta.FastaVisitor;
import org.jcvi.jillion.fasta.FastaVisitorCallback;
import org.jcvi.jillion.internal.core.util.iter.AbstractBlockingStreamingIterator;

public final class LargeFastaIdIterator
extends AbstractBlockingStreamingIterator<String> {
    private final FastaParser parser;
    private final Predicate<String> filter;

    public static LargeFastaIdIterator createNewIteratorFor(FastaParser parser, Predicate<String> filter) {
        if (parser == null) {
            throw new NullPointerException("fasta file can not be null");
        }
        if (filter == null) {
            throw new NullPointerException("filter can not be null");
        }
        LargeFastaIdIterator iter = new LargeFastaIdIterator(parser, filter);
        iter.start();
        return iter;
    }

    public static LargeFastaIdIterator createNewIteratorFor(FastaParser parser) {
        return LargeFastaIdIterator.createNewIteratorFor(parser, DataStoreFilters.alwaysAccept());
    }

    private LargeFastaIdIterator(FastaParser parser, Predicate<String> filter) {
        this.parser = parser;
        this.filter = filter;
    }

    @Override
    protected void backgroundThreadRunMethod() {
        FastaVisitor visitor = new FastaVisitor(){

            @Override
            public FastaRecordVisitor visitDefline(FastaVisitorCallback callback, String id, String optionalComment) {
                if (LargeFastaIdIterator.this.filter.test(id)) {
                    LargeFastaIdIterator.this.blockingPut(id);
                }
                return null;
            }

            @Override
            public void visitEnd() {
            }

            @Override
            public void halted() {
            }
        };
        try {
            this.parser.parse(visitor);
        }
        catch (IOException e) {
            throw new RuntimeException("fasta file does not exist", e);
        }
    }
}

