/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.internal.fasta;

import java.io.IOException;
import java.util.Comparator;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.jcvi.jillion.core.Sequence;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.fasta.FastaRecord;
import org.jcvi.jillion.fasta.FastaWriter;

public abstract class InMemorySortedFastaWriter<S, T extends Sequence<S>, F extends FastaRecord<S, T>>
implements FastaWriter<S, T, F> {
    private final FastaWriter<S, T, F> writer;
    private final Set<F> sorted;
    private volatile boolean closed;

    public InMemorySortedFastaWriter(FastaWriter<S, T, F> writer, Comparator<F> comparator) {
        Objects.requireNonNull(writer);
        Objects.requireNonNull(comparator);
        this.writer = writer;
        this.sorted = new TreeSet<F>(comparator);
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            for (FastaRecord record : this.sorted) {
                this.writer.write(record);
            }
        }
        finally {
            this.sorted.clear();
            IOUtil.closeAndIgnoreErrors(this.writer);
        }
    }

    private void checkNotClosed() throws IOException {
        if (this.closed) {
            throw new IOException("writer is closed");
        }
    }

    @Override
    public synchronized void write(F record) throws IOException {
        this.checkNotClosed();
        this.sorted.add(record);
    }

    @Override
    public void write(String id, T sequence) throws IOException {
        this.write(id, sequence, null);
    }

    @Override
    public void write(String id, T sequence, String optionalComment) throws IOException {
        this.write(this.createRecord(id, sequence, optionalComment));
    }

    protected abstract F createRecord(String var1, T var2, String var3);
}

