/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.internal.fasta;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jcvi.jillion.core.io.InputStreamSupplier;
import org.jcvi.jillion.core.util.JoinedStringBuilder;
import org.jcvi.jillion.internal.core.io.TextLineParser;

public final class FastaUtil {
    private static final String LINE_SEPARATOR = "\n";
    private static final char HEADER_PREFIX = '>';
    private static final Pattern ID_LINE_PATTERN = Pattern.compile("^>(\\S+)(\\s+(.*))?");
    private static final Pattern REDUNDANT_ID_LINE_PATTERN = Pattern.compile("(\\S+)(\\s+(.*))?");
    private static final char CONTROL_A = '\u0001';
    private static final Pattern NON_REDUNDANT_SPLIT = Pattern.compile(Pattern.quote(Character.toString('\u0001')));

    private FastaUtil() {
    }

    public static String getLineSeparator() {
        return LINE_SEPARATOR;
    }

    public static char getHeaderPrefix() {
        return '>';
    }

    public static char getNonRedundantSeparator() {
        return '\u0001';
    }

    public static void createIndex(File fastaFile, PrintWriter out, String eol, Function<String, Integer> numberOfBases) throws IOException {
        try (InputStream in = InputStreamSupplier.forFile(fastaFile).get();
             TextLineParser parser = new TextLineParser(in);){
            while (parser.hasNextLine()) {
                FastaUtil.handleNextFastaRecord(parser, out, eol, numberOfBases);
            }
        }
    }

    private static void handleNextFastaRecord(TextLineParser parser, PrintWriter out, String eol, Function<String, Integer> numberOfBases) throws IOException {
        String line = parser.nextLine();
        while (line != null && line.charAt(0) != '>') {
            line = parser.nextLine();
        }
        if (line == null) {
            return;
        }
        Matcher matcher = ID_LINE_PATTERN.matcher(line);
        if (!matcher.find()) {
            throw new IllegalStateException("invalid fasta file defline ='" + line.trim() + "'");
        }
        String[] redundantIds = NON_REDUNDANT_SPLIT.split(line.trim().substring(1));
        String id = matcher.group(1);
        long sequenceStart = parser.getPosition();
        String firstLine = parser.nextLine();
        long currentPosition = parser.getPosition();
        long numberOfBytesPerLineIncludingEol = currentPosition - sequenceStart;
        int numberOfBasesPerLine = numberOfBases.apply(firstLine);
        long seqLength = numberOfBasesPerLine;
        while (parser.hasNextLine() && parser.peekLine().charAt(0) != '>') {
            String nextLine = parser.nextLine();
            long lastPosition = currentPosition;
            currentPosition = parser.getPosition();
            long bytesInThisLine = currentPosition - lastPosition;
            if (!(bytesInThisLine == numberOfBytesPerLineIncludingEol || FastaUtil.lastLineOfRecord(parser) && bytesInThisLine <= numberOfBytesPerLineIncludingEol)) {
                throw new IOException(String.format("invalid fasta file, different length seq lines in record '%s', all but last row must be %d bytes, but line at offset %d was %d bytes", id, numberOfBytesPerLineIncludingEol, lastPosition, bytesInThisLine));
            }
            int numBases = numberOfBases.apply(nextLine);
            if (!(numBases == numberOfBasesPerLine || FastaUtil.lastLineOfRecord(parser) && numBases <= numberOfBasesPerLine)) {
                throw new IOException(String.format("invalid fasta file, different length seq lines in record '%s', all but last row must be %d bases, but line at offset %d was %d bases", id, numberOfBasesPerLine, lastPosition, numBases));
            }
            seqLength += (long)numBases;
        }
        for (String redundantId : redundantIds) {
            ArrayList<String> fields = new ArrayList<String>(5);
            Matcher m = REDUNDANT_ID_LINE_PATTERN.matcher(redundantId);
            if (!m.find()) {
                throw new IOException("error parsing id from non-redundant line: " + redundantId);
            }
            fields.add(m.group(1));
            fields.add(Long.toString(seqLength));
            fields.add(Long.toString(sequenceStart));
            fields.add(Long.toString(numberOfBasesPerLine));
            fields.add(Long.toString(numberOfBytesPerLineIncludingEol));
            out.print(JoinedStringBuilder.create(fields).glue(Character.valueOf('\t')).suffix(eol).build());
        }
    }

    private static boolean lastLineOfRecord(TextLineParser parser) {
        return !parser.hasNextLine() || parser.peekLine().charAt(0) == '>';
    }
}

