/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.internal.fasta;

import java.io.IOException;
import java.io.InputStream;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.io.InputStreamSupplier;

public final class FastaIndexRecord {
    private final long seqLength;
    private final long firstBaseOffset;
    private final int basesPerLine;
    private final int bytesPerLineIncludingEol;

    public FastaIndexRecord(long seqLength, long firstBaseOffset, int basesPerLine, int bytesPerLineIncludingEol) {
        if (seqLength < 0L) {
            throw new IllegalArgumentException("seq length can not be negative");
        }
        if (firstBaseOffset < 2L) {
            throw new IllegalArgumentException("first base offset can not be negative");
        }
        if (basesPerLine < 0) {
            throw new IllegalArgumentException("bases per line can not be negative");
        }
        if (bytesPerLineIncludingEol < basesPerLine) {
            throw new IllegalArgumentException("bytes per line  can not be less than bases per line");
        }
        this.seqLength = seqLength;
        this.firstBaseOffset = firstBaseOffset;
        this.basesPerLine = basesPerLine;
        this.bytesPerLineIncludingEol = bytesPerLineIncludingEol;
    }

    public long computeFileOffset(long sequenceOffset) {
        if (sequenceOffset < 0L) {
            throw new IllegalArgumentException("seq offset must be >=0");
        }
        if (sequenceOffset >= this.seqLength) {
            throw new IllegalArgumentException("seq offset " + sequenceOffset + "must be < sequence length " + this.seqLength);
        }
        return this.firstBaseOffset + sequenceOffset / (long)this.basesPerLine * (long)this.bytesPerLineIncludingEol + sequenceOffset % (long)this.basesPerLine;
    }

    public Range computeFileOffsetRange(Range sequenceOffsetRange) {
        return Range.of(this.computeFileOffset(sequenceOffsetRange.getBegin()), this.computeFileOffset(sequenceOffsetRange.getEnd()));
    }

    public InputStream newInputStream(InputStreamSupplier fastaFile) throws IOException {
        Range range = this.computeFileOffsetRange(Range.ofLength(this.seqLength));
        return fastaFile.get(range);
    }

    public InputStream newInputStream(InputStreamSupplier fastaFile, Range sequenceRange) throws IOException {
        Range offsetRange = this.computeFileOffsetRange(sequenceRange);
        return fastaFile.get(offsetRange);
    }

    public InputStream newInputStream(InputStreamSupplier fastaFile, long sequenceStartOffset) throws IOException {
        Range range = new Range.Builder(this.seqLength).contractBegin(sequenceStartOffset).build();
        return this.newInputStream(fastaFile, range);
    }

    public long getSeqLength() {
        return this.seqLength;
    }

    public String toString() {
        return "FastaIndexRecord [seqLength=" + this.seqLength + ", firstBaseOffset=" + this.firstBaseOffset + ", basesPerLine=" + this.basesPerLine + ", bytesPerLineIncludingEol=" + this.bytesPerLineIncludingEol + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.basesPerLine;
        result = 31 * result + this.bytesPerLineIncludingEol;
        result = 31 * result + (int)(this.firstBaseOffset ^ this.firstBaseOffset >>> 32);
        result = 31 * result + (int)(this.seqLength ^ this.seqLength >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FastaIndexRecord)) {
            return false;
        }
        FastaIndexRecord other = (FastaIndexRecord)obj;
        if (this.basesPerLine != other.basesPerLine) {
            return false;
        }
        if (this.bytesPerLineIncludingEol != other.bytesPerLineIncludingEol) {
            return false;
        }
        if (this.firstBaseOffset != other.firstBaseOffset) {
            return false;
        }
        return this.seqLength == other.seqLength;
    }
}

