/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.internal.fasta;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.internal.fasta.FastaIndex;
import org.jcvi.jillion.internal.fasta.FastaIndexRecord;

public class DefaultFastaIndex
implements FastaIndex {
    private static final Pattern FIELD_SEPARATOR = Pattern.compile("\t");
    private final Map<String, FastaIndexRecord> map;

    DefaultFastaIndex(Map<String, FastaIndexRecord> map) {
        this.map = map;
    }

    @Override
    public FastaIndexRecord getIndexFor(String id) {
        return this.map.get(id);
    }

    public static FastaIndex parse(File fai) throws IOException {
        return DefaultFastaIndex.parse(fai, "UTF-8");
    }

    public static FastaIndex parse(File fai, String charsetName) throws IOException {
        HashMap<String, FastaIndexRecord> map = new HashMap<String, FastaIndexRecord>();
        try (BufferedReader reader = IOUtil.createNewBufferedReader(fai, charsetName);){
            String line;
            while ((line = reader.readLine()) != null) {
                String[] fields = FIELD_SEPARATOR.split(line);
                FastaIndexRecord record = new FastaIndexRecord(Long.parseLong(fields[1]), Long.parseLong(fields[2]), Integer.parseInt(fields[3]), Integer.parseInt(fields[4]));
                map.put(fields[0], record);
            }
        }
        return new DefaultFastaIndex(map);
    }
}

