/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.internal.fasta;

import java.io.IOException;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jcvi.jillion.core.Sequence;
import org.jcvi.jillion.core.datastore.DataStore;
import org.jcvi.jillion.core.datastore.DataStoreClosedException;
import org.jcvi.jillion.core.datastore.DataStoreEntry;
import org.jcvi.jillion.core.datastore.DataStoreException;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.util.iter.StreamingIterator;
import org.jcvi.jillion.core.util.streams.ThrowingBiConsumer;
import org.jcvi.jillion.fasta.FastaDataStore;
import org.jcvi.jillion.fasta.FastaParser;
import org.jcvi.jillion.fasta.FastaRecord;
import org.jcvi.jillion.fasta.FastaRecordVisitor;
import org.jcvi.jillion.fasta.FastaVisitor;
import org.jcvi.jillion.fasta.FastaVisitorCallback;
import org.jcvi.jillion.internal.core.datastore.DataStoreStreamingIterator;
import org.jcvi.jillion.internal.core.util.Sneak;
import org.jcvi.jillion.internal.fasta.LargeFastaIdIterator;

public abstract class AbstractLargeFastaFileDataStore<T, S extends Sequence<T>, F extends FastaRecord<T, S>, D extends DataStore<S>>
implements FastaDataStore<T, S, F, D> {
    private final FastaParser parser;
    private final Predicate<String> filter;
    private final Predicate<F> recordFilter;
    private Long size;
    private volatile boolean closed = false;

    protected AbstractLargeFastaFileDataStore(FastaParser parser, Predicate<String> filter, Predicate<F> recordFilter) {
        if (parser == null) {
            throw new NullPointerException("fasta parser can not be null");
        }
        if (filter == null) {
            throw new NullPointerException("filter file can not be null");
        }
        this.filter = filter;
        this.parser = parser;
        this.recordFilter = recordFilter;
    }

    private void checkNotYetClosed() {
        if (this.closed) {
            throw new DataStoreClosedException("already closed");
        }
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public boolean contains(String id) throws DataStoreException {
        this.checkNotYetClosed();
        return this.get(id) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public F get(String id) throws DataStoreException {
        StreamingIterator<F> iter = this.iterator();
        try {
            while (iter.hasNext()) {
                FastaRecord next = (FastaRecord)iter.next();
                if (!next.getId().equals(id)) continue;
                FastaRecord fastaRecord = next;
                return (F)fastaRecord;
            }
            F f = null;
            return f;
        }
        finally {
            IOUtil.closeAndIgnoreErrors(iter);
        }
    }

    protected abstract FastaRecordVisitor createRecordVisitor(String var1, String var2, Consumer<F> var3);

    @Override
    public <E extends Throwable> void forEach(final ThrowingBiConsumer<String, F, E> consumer) throws IOException, E {
        this.checkNotYetClosed();
        if (this.recordFilter == null) {
            this.parser.parse(new FastaVisitor(){

                @Override
                public void visitEnd() {
                }

                @Override
                public FastaRecordVisitor visitDefline(FastaVisitorCallback callback, String id, String optionalComment) {
                    if (AbstractLargeFastaFileDataStore.this.filter.test(id)) {
                        return AbstractLargeFastaFileDataStore.this.createRecordVisitor(id, optionalComment, r -> {
                            try {
                                consumer.accept(id, r);
                            }
                            catch (Throwable t) {
                                Sneak.sneakyThrow(t);
                            }
                        });
                    }
                    return null;
                }

                @Override
                public void halted() {
                }
            });
        } else {
            this.parser.parse(new FastaVisitor(){

                @Override
                public void visitEnd() {
                }

                @Override
                public FastaRecordVisitor visitDefline(FastaVisitorCallback callback, String id, String optionalComment) {
                    if (AbstractLargeFastaFileDataStore.this.filter.test(id)) {
                        return AbstractLargeFastaFileDataStore.this.createRecordVisitor(id, optionalComment, r -> {
                            if (AbstractLargeFastaFileDataStore.this.recordFilter.test(r)) {
                                try {
                                    consumer.accept(id, r);
                                }
                                catch (Throwable t) {
                                    Sneak.sneakyThrow(t);
                                }
                            }
                        });
                    }
                    return null;
                }

                @Override
                public void halted() {
                }
            });
        }
    }

    @Override
    public StreamingIterator<String> idIterator() throws DataStoreException {
        this.checkNotYetClosed();
        if (this.recordFilter == null) {
            return DataStoreStreamingIterator.create(this, LargeFastaIdIterator.createNewIteratorFor(this.parser, this.filter));
        }
        return new AdditionalRecordFilteringIdIterator(this.iterator());
    }

    @Override
    public synchronized long getNumberOfRecords() throws DataStoreException {
        this.checkNotYetClosed();
        if (this.size == null) {
            if (this.recordFilter == null) {
                try {
                    NoAdditionalRecordFilteringSizeCounter visitor = new NoAdditionalRecordFilteringSizeCounter();
                    this.parser.parse(visitor);
                    this.size = visitor.getSize();
                }
                catch (IOException e) {
                    throw new IllegalStateException("could not get record count", e);
                }
            }
            long temp = 0L;
            try (StreamingIterator<F> iter = this.iterator();){
                while (iter.hasNext()) {
                    iter.next();
                    ++temp;
                }
            }
            this.size = temp;
        }
        return this.size;
    }

    @Override
    public final StreamingIterator<F> iterator() throws DataStoreException {
        this.checkNotYetClosed();
        return this.createNewIterator(this.parser, this.filter, this.recordFilter);
    }

    protected abstract StreamingIterator<F> createNewIterator(FastaParser var1, Predicate<String> var2, Predicate<F> var3) throws DataStoreException;

    @Override
    public final StreamingIterator<DataStoreEntry<F>> entryIterator() throws DataStoreException {
        this.checkNotYetClosed();
        return new StreamingIterator<DataStoreEntry<F>>(){
            StreamingIterator<F> iter;
            {
                this.iter = AbstractLargeFastaFileDataStore.this.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public void close() {
                this.iter.close();
            }

            @Override
            public DataStoreEntry<F> next() {
                FastaRecord next = (FastaRecord)this.iter.next();
                return new DataStoreEntry<FastaRecord>(next.getId(), next);
            }

            @Override
            public void remove() {
                this.iter.remove();
            }
        };
    }

    private final class AdditionalRecordFilteringIdIterator
    implements StreamingIterator<String> {
        private final StreamingIterator<F> iter;

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public void close() {
            this.iter.close();
        }

        @Override
        public String next() {
            return ((FastaRecord)this.iter.next()).getId();
        }

        public AdditionalRecordFilteringIdIterator(StreamingIterator<F> iter) {
            this.iter = iter;
        }
    }

    private final class NoAdditionalRecordFilteringSizeCounter
    implements FastaVisitor {
        long numDeflines = 0L;

        private NoAdditionalRecordFilteringSizeCounter() {
        }

        @Override
        public FastaRecordVisitor visitDefline(FastaVisitorCallback callback, String id, String optionalComment) {
            if (AbstractLargeFastaFileDataStore.this.filter.test(id)) {
                ++this.numDeflines;
            }
            return null;
        }

        public long getSize() {
            return this.numDeflines;
        }

        @Override
        public void visitEnd() {
        }

        @Override
        public void halted() {
            throw new IllegalStateException("parser was halted when trying to compute size");
        }
    }
}

