/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.internal.core.util.iter;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Objects;

public class PushBackIterator<T>
implements Iterator<T> {
    private final Iterator<T> delegate;
    private final LinkedList<T> pushedBackList = new LinkedList();

    public PushBackIterator(Iterator<T> delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public boolean hasNext() {
        return !this.pushedBackList.isEmpty() || this.delegate.hasNext();
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (!this.pushedBackList.isEmpty()) {
            return this.pushedBackList.pop();
        }
        return this.delegate.next();
    }

    public void pushBack(T t) {
        this.pushedBackList.add(t);
    }
}

