/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.internal.core.util.iter;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jcvi.jillion.core.util.iter.IteratorUtil;

public final class PrimitiveArrayIterators {
    private PrimitiveArrayIterators() {
    }

    public static Iterator<Integer> create(int[] array) {
        return new IntIterator(array, 0, array.length - 1);
    }

    public static Iterator<Integer> create(int[] array, int length) {
        int arrayLength = array.length;
        PrimitiveArrayIterators.validateParameters(length, arrayLength);
        if (length == 0) {
            return IteratorUtil.createEmptyIterator();
        }
        return new IntIterator(array, 0, length - 1);
    }

    public static void validateParameters(int length, int arrayLength) {
        if (length > arrayLength) {
            throw new IllegalArgumentException("given length must be <= array.length");
        }
        if (length < 0) {
            throw new IllegalArgumentException("length must be >=0");
        }
    }

    public static Iterator<Integer> create(int[] array, int start, int end) {
        PrimitiveArrayIterators.validateParameters(start, end, array.length);
        return new IntIterator(array, start, end);
    }

    public static void validateParameters(int start, int end, int arrayLength) {
        if (start < 0 || start >= arrayLength) {
            throw new ArrayIndexOutOfBoundsException("start " + start + " array length = " + arrayLength);
        }
        if (end < 0 || end >= arrayLength) {
            throw new ArrayIndexOutOfBoundsException("end " + end + " array length = " + arrayLength);
        }
        if (start > end) {
            throw new IllegalArgumentException("start > end" + start + "  " + end);
        }
    }

    public static Iterator<Byte> create(byte[] array) {
        return new ByteIterator(array, 0, array.length - 1);
    }

    public static Iterator<Byte> create(byte[] array, int length) {
        int arrayLength = array.length;
        PrimitiveArrayIterators.validateParameters(length, arrayLength);
        if (length == 0) {
            return IteratorUtil.createEmptyIterator();
        }
        return new ByteIterator(array, 0, length - 1);
    }

    public static Iterator<Byte> create(byte[] array, int start, int end) {
        PrimitiveArrayIterators.validateParameters(start, end, array.length);
        return new ByteIterator(array, start, end);
    }

    public static Iterator<Short> create(short[] array) {
        return new ShortIterator(array, 0, array.length - 1);
    }

    public static Iterator<Short> create(short[] array, int length) {
        int arrayLength = array.length;
        PrimitiveArrayIterators.validateParameters(length, arrayLength);
        if (length == 0) {
            return IteratorUtil.createEmptyIterator();
        }
        return new ShortIterator(array, 0, length - 1);
    }

    public static Iterator<Short> create(short[] array, int start, int end) {
        PrimitiveArrayIterators.validateParameters(start, end, array.length);
        return new ShortIterator(array, start, end);
    }

    public static Iterator<Character> create(char[] array) {
        return new CharIterator(array, 0, array.length - 1);
    }

    public static Iterator<Character> create(char[] array, int length) {
        int arrayLength = array.length;
        PrimitiveArrayIterators.validateParameters(length, arrayLength);
        if (length == 0) {
            return IteratorUtil.createEmptyIterator();
        }
        return new CharIterator(array, 0, length - 1);
    }

    public static Iterator<Character> create(char[] array, int start, int end) {
        PrimitiveArrayIterators.validateParameters(start, end, array.length);
        return new CharIterator(array, start, end);
    }

    public static Iterator<Long> create(long[] array) {
        return new LongIterator(array, 0, array.length - 1);
    }

    public static Iterator<Long> create(long[] array, int length) {
        int arrayLength = array.length;
        PrimitiveArrayIterators.validateParameters(length, arrayLength);
        if (length == 0) {
            return IteratorUtil.createEmptyIterator();
        }
        return new LongIterator(array, 0, length - 1);
    }

    public static Iterator<Long> create(long[] array, int start, int end) {
        PrimitiveArrayIterators.validateParameters(start, end, array.length);
        return new LongIterator(array, start, end);
    }

    private static class LongIterator
    implements Iterator<Long> {
        private final long[] array;
        private int currentOffset;
        private final int endOffset;

        public LongIterator(long[] array, int start, int end) {
            this.array = array;
            this.endOffset = end;
            this.currentOffset = start;
        }

        @Override
        public boolean hasNext() {
            return this.currentOffset <= this.endOffset;
        }

        @Override
        public Long next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Long next = this.array[this.currentOffset];
            ++this.currentOffset;
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class CharIterator
    implements Iterator<Character> {
        private final char[] array;
        private int currentOffset;
        private final int endOffset;

        public CharIterator(char[] array, int start, int end) {
            this.array = array;
            this.endOffset = end;
            this.currentOffset = start;
        }

        @Override
        public boolean hasNext() {
            return this.currentOffset <= this.endOffset;
        }

        @Override
        public Character next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Character next = Character.valueOf(this.array[this.currentOffset]);
            ++this.currentOffset;
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class ShortIterator
    implements Iterator<Short> {
        private final short[] array;
        private int currentOffset;
        private final int endOffset;

        public ShortIterator(short[] array, int start, int end) {
            this.array = array;
            this.endOffset = end;
            this.currentOffset = start;
        }

        @Override
        public boolean hasNext() {
            return this.currentOffset <= this.endOffset;
        }

        @Override
        public Short next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Short next = this.array[this.currentOffset];
            ++this.currentOffset;
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class ByteIterator
    implements Iterator<Byte> {
        private final byte[] array;
        private int currentOffset;
        private final int endOffset;

        public ByteIterator(byte[] array, int start, int end) {
            this.array = array;
            this.endOffset = end;
            this.currentOffset = start;
        }

        @Override
        public boolean hasNext() {
            return this.currentOffset <= this.endOffset;
        }

        @Override
        public Byte next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Byte next = this.array[this.currentOffset];
            ++this.currentOffset;
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class IntIterator
    implements Iterator<Integer> {
        private final int[] array;
        private int currentOffset;
        private final int endOffset;

        public IntIterator(int[] array, int start, int end) {
            this.array = array;
            this.endOffset = end;
            this.currentOffset = start;
        }

        @Override
        public boolean hasNext() {
            return this.currentOffset <= this.endOffset;
        }

        @Override
        public Integer next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Integer next = this.array[this.currentOffset];
            ++this.currentOffset;
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

