/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.internal.core.util.iter;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.jcvi.jillion.core.util.iter.IteratorUtil;
import org.jcvi.jillion.core.util.iter.PeekableStreamingIterator;

public class MergedSortedRecordIterator<T>
implements Iterator<T> {
    private final List<PeekableStreamingIterator<T>> iterators = new ArrayList<PeekableStreamingIterator<T>>();
    private T next;
    private final Comparator<T> comparator;

    public MergedSortedRecordIterator(List<? extends Iterator<T>> iterators, Comparator<T> comparator) {
        for (Iterator<T> iter : iterators) {
            if (iterators.isEmpty()) continue;
            this.iterators.add(IteratorUtil.createPeekableStreamingIterator(iter));
        }
        this.comparator = comparator;
        this.next = this.getNext();
    }

    private T getNext() {
        PeekableStreamingIterator<T> currentIter;
        Object bestElement = null;
        PeekableStreamingIterator<T> bestIter = null;
        Iterator<PeekableStreamingIterator<T>> iter = this.iterators.iterator();
        if (!iter.hasNext()) {
            return null;
        }
        do {
            if (!(currentIter = iter.next()).hasNext()) continue;
            bestElement = currentIter.peek();
            bestIter = currentIter;
        } while (iter.hasNext() && bestElement == null);
        while (iter.hasNext()) {
            Object currentElement;
            currentIter = iter.next();
            if (!currentIter.hasNext() || this.comparator.compare(currentElement = currentIter.peek(), bestElement) >= 0) continue;
            bestIter = currentIter;
            bestElement = currentElement;
        }
        if (bestIter == null) {
            return null;
        }
        return bestIter.next();
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public T next() {
        T ret = this.next;
        this.next = this.getNext();
        return ret;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

