/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.internal.core.util.iter;

import java.io.Closeable;
import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.util.iter.StreamingIterator;

public abstract class AbstractBlockingStreamingIterator<T>
implements StreamingIterator<T> {
    private final Object endOfFileToken = new Object();
    private final BlockingQueue<Object> queue = new LinkedBlockingQueue<Object>(1);
    private volatile Object nextRecord = null;
    private volatile boolean isClosed = false;
    private volatile RuntimeException uncaughtException;

    private void blockingGetNextRecord() {
        if (!this.isClosed) {
            try {
                Object obj = null;
                while (obj == null) {
                    obj = this.queue.poll(1L, TimeUnit.SECONDS);
                    if (obj == null) {
                        if (this.uncaughtException == null) continue;
                        this.nextRecord = null;
                        break;
                    }
                    this.nextRecord = obj;
                }
            }
            catch (InterruptedException e) {
                IOUtil.closeAndIgnoreErrors((Closeable)this);
            }
        }
    }

    public void start() {
        final IteratorThread iteratorThread = new IteratorThread();
        iteratorThread.start();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                iteratorThread.kill();
            }
        });
        this.blockingGetNextRecord();
    }

    protected abstract void backgroundThreadRunMethod() throws RuntimeException;

    private void finishedIterating() {
        this.blockingPut(this.endOfFileToken);
    }

    public final void blockingPut(Object obj) {
        if (!this.isClosed) {
            try {
                this.queue.put(obj);
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    @Override
    public final void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void close() {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        this.nextRecord = this.endOfFileToken;
        this.queue.clear();
    }

    private void setErroredOut(RuntimeException uncaughtException) {
        this.uncaughtException = uncaughtException;
        this.nextRecord = this.endOfFileToken;
        this.queue.clear();
    }

    protected void finalize() throws IOException {
        if (!this.isClosed) {
            this.close();
        }
    }

    @Override
    public final T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("no records");
        }
        Object next = this.nextRecord;
        this.blockingGetNextRecord();
        return (T)next;
    }

    @Override
    public final boolean hasNext() {
        if (!this.isClosed && this.uncaughtException != null) {
            throw this.uncaughtException;
        }
        return !this.isClosed && this.nextRecord != this.endOfFileToken;
    }

    public final boolean isClosed() {
        return this.isClosed;
    }

    private class IteratorThread
    extends Thread {
        private IteratorThread() {
        }

        public void kill() {
            IOUtil.closeAndIgnoreErrors((Closeable)AbstractBlockingStreamingIterator.this);
        }

        @Override
        public void run() {
            try {
                AbstractBlockingStreamingIterator.this.backgroundThreadRunMethod();
                AbstractBlockingStreamingIterator.this.finishedIterating();
            }
            catch (RuntimeException e) {
                AbstractBlockingStreamingIterator.this.setErroredOut(e);
            }
        }
    }
}

