/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.internal.core.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.stream.LongStream;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.util.streams.ThrowingIntIndexedLongConsumer;
import org.jcvi.jillion.internal.core.util.iter.PrimitiveArrayIterators;

public final class GrowableLongArray
implements Iterable<Long> {
    private int currentLength = 0;
    private long[] data;

    public GrowableLongArray(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity should be >= 0 :" + initialCapacity);
        }
        this.data = new long[initialCapacity];
    }

    public GrowableLongArray(Collection<Long> longs) {
        this.data = new long[longs.size()];
        int index = 0;
        for (Long i : longs) {
            this.data[index] = i;
            ++index;
        }
        this.currentLength = this.data.length;
    }

    public GrowableLongArray(long[] longs) {
        this.data = Arrays.copyOf(longs, longs.length);
        this.currentLength = this.data.length;
    }

    private GrowableLongArray(GrowableLongArray copy) {
        this.data = Arrays.copyOf(copy.data, copy.data.length);
        this.currentLength = copy.currentLength;
    }

    public GrowableLongArray copy() {
        return new GrowableLongArray(this);
    }

    private void assertValidOffset(int offset) {
        if (offset < 0 || offset >= this.currentLength) {
            throw new IndexOutOfBoundsException("Index: " + offset + ", Size: " + this.currentLength);
        }
    }

    private void assertValidRange(Range range) {
        if (range.getBegin() < 0L || range.getEnd() >= (long)this.currentLength) {
            throw new IndexOutOfBoundsException("range: " + range + ", array size: " + this.currentLength);
        }
    }

    public void reverse() {
        int pivotPoint = this.currentLength / 2;
        for (int i = 0; i < pivotPoint; ++i) {
            long temp = this.data[i];
            int reverseI = this.currentLength - i - 1;
            this.data[i] = this.data[reverseI];
            this.data[reverseI] = temp;
        }
    }

    public int getCurrentLength() {
        return this.currentLength;
    }

    public void append(long value) {
        this.ensureCapacity(this.currentLength + 1);
        this.data[this.currentLength++] = value;
    }

    public void append(long[] values) {
        this.ensureCapacity(this.currentLength + values.length);
        System.arraycopy(values, 0, this.data, this.currentLength, values.length);
        this.currentLength += values.length;
    }

    public void append(GrowableLongArray other) {
        this.ensureCapacity(this.currentLength + other.currentLength);
        System.arraycopy(other.data, 0, this.data, this.currentLength, other.currentLength);
        this.currentLength += other.currentLength;
    }

    public long get(int offset) {
        this.assertValidOffset(offset);
        return this.data[offset];
    }

    public void prepend(long value) {
        this.insert(0, value);
    }

    public void prepend(long[] values) {
        this.insert(0, values);
    }

    public void prepend(GrowableLongArray other) {
        this.insert(0, other);
    }

    public void replace(int offset, long value) {
        this.assertValidOffset(offset);
        this.data[offset] = value;
    }

    public void insert(int offset, long[] values) {
        this.assertValidInsertOffset(offset);
        this.ensureCapacity(this.currentLength + values.length);
        System.arraycopy(this.data, offset, this.data, offset + values.length, this.currentLength - offset);
        System.arraycopy(values, 0, this.data, offset, values.length);
        this.currentLength += values.length;
    }

    public void insert(int offset, GrowableLongArray other) {
        this.assertValidInsertOffset(offset);
        this.ensureCapacity(this.currentLength + other.currentLength);
        System.arraycopy(this.data, offset, this.data, offset + other.currentLength, this.currentLength - offset);
        System.arraycopy(other.data, 0, this.data, offset, other.currentLength);
        this.currentLength += other.currentLength;
    }

    public void insert(int offset, long value) {
        this.assertValidInsertOffset(offset);
        this.ensureCapacity(this.currentLength + 1);
        System.arraycopy(this.data, offset, this.data, offset + 1, this.currentLength - offset);
        this.data[offset] = value;
        ++this.currentLength;
    }

    private void assertValidInsertOffset(int offset) {
        if (offset != this.currentLength) {
            this.assertValidOffset(offset);
        }
    }

    public void remove(Range range) {
        this.assertValidRange(range);
        int numMoved = this.currentLength - (int)range.getBegin() - (int)range.getLength();
        if (numMoved > 0) {
            System.arraycopy(this.data, (int)range.getEnd() + 1, this.data, (int)range.getBegin(), numMoved);
        }
        this.currentLength -= (int)range.getLength();
    }

    public long remove(int offset) {
        this.assertValidOffset(offset);
        long oldValue = this.data[offset];
        int numMoved = this.currentLength - offset - 1;
        if (numMoved > 0) {
            System.arraycopy(this.data, offset + 1, this.data, offset, numMoved);
        }
        --this.currentLength;
        return oldValue;
    }

    public int getCurrentCapacity() {
        return this.data.length;
    }

    private void ensureCapacity(int minCapacity) {
        int oldCapacity = this.data.length;
        if (minCapacity > oldCapacity) {
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.data = Arrays.copyOf(this.data, newCapacity);
        }
    }

    public long[] toArray() {
        return Arrays.copyOf(this.data, this.currentLength);
    }

    public int binarySearch(long key) {
        return Arrays.binarySearch(this.data, 0, this.currentLength, key);
    }

    public boolean sortedRemove(long value) {
        int index = this.binarySearch(value);
        if (index >= 0) {
            this.remove(index);
            return true;
        }
        return false;
    }

    public int sortedInsert(long value) {
        int index = this.binarySearch(value);
        if (index < 0) {
            index = -index - 1;
        }
        this.insert(index, value);
        return index;
    }

    public void sort() {
        Arrays.sort(this.data, 0, this.currentLength);
    }

    public void clear() {
        this.currentLength = 0;
    }

    @Override
    public Iterator<Long> iterator() {
        return PrimitiveArrayIterators.create(this.data, this.currentLength);
    }

    public void sortedInsert(long[] values) {
        if (values.length == 0) {
            return;
        }
        if (this.currentLength == 0) {
            this.append(values);
            return;
        }
        long[] newData = new long[this.data.length + values.length];
        int newCurrentLength = this.currentLength + values.length;
        int ourDataIndex = 0;
        int otherDataIndex = 0;
        long ourNextValue = this.data[0];
        long otherNextValue = values[0];
        int i = 0;
        while (ourDataIndex < this.currentLength && otherDataIndex < values.length) {
            if (ourNextValue < otherNextValue) {
                newData[i] = ourNextValue;
                if (++ourDataIndex < this.currentLength) {
                    ourNextValue = this.data[ourDataIndex];
                }
            } else {
                newData[i] = otherNextValue;
                if (++otherDataIndex < values.length) {
                    otherNextValue = values[otherDataIndex];
                }
            }
            ++i;
        }
        if (ourDataIndex < this.currentLength) {
            while (ourDataIndex < this.currentLength) {
                newData[i] = this.data[ourDataIndex];
                ++i;
                ++ourDataIndex;
            }
        } else {
            while (otherDataIndex < values.length) {
                newData[i] = values[otherDataIndex];
                ++i;
                ++otherDataIndex;
            }
        }
        this.data = newData;
        this.currentLength = newCurrentLength;
    }

    public int getCount(long value) {
        int count = 0;
        for (int i = 0; i < this.currentLength; ++i) {
            if (this.data[i] != value) continue;
            ++count;
        }
        return count;
    }

    public LongStream stream() {
        return Arrays.stream(this.data, 0, this.currentLength);
    }

    public <E extends Throwable> void forEachIndexed(ThrowingIntIndexedLongConsumer<E> consumer) throws E {
        Objects.requireNonNull(consumer);
        for (int i = 0; i < this.currentLength; ++i) {
            consumer.accept(i, this.data[i]);
        }
    }

    public <E extends Throwable> void forEachIndexed(Range range, ThrowingIntIndexedLongConsumer<E> consumer) throws E {
        int end = (int)Math.min((long)this.currentLength, range.getEnd() + 1L);
        for (int i = (int)range.getBegin(); i < end; ++i) {
            consumer.accept(i, this.data[i]);
        }
    }
}

