/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.internal.core.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.util.streams.ThrowingIntIndexedIntConsumer;
import org.jcvi.jillion.internal.core.util.ArrayUtil;
import org.jcvi.jillion.internal.core.util.iter.PrimitiveArrayIterators;

public final class GrowableIntArray
implements Iterable<Integer> {
    private int currentLength = 0;
    private int[] data;

    public GrowableIntArray(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity should be >= 0 :" + initialCapacity);
        }
        this.data = new int[initialCapacity];
    }

    public GrowableIntArray(Collection<Integer> ints) {
        this.data = new int[ints.size()];
        int index = 0;
        for (Integer i : ints) {
            this.data[index] = i;
            ++index;
        }
        this.currentLength = this.data.length;
    }

    public GrowableIntArray(int[] ints) {
        this.data = Arrays.copyOf(ints, ints.length);
        this.currentLength = this.data.length;
    }

    private GrowableIntArray(GrowableIntArray copy) {
        this.data = Arrays.copyOf(copy.data, copy.data.length);
        this.currentLength = copy.currentLength;
    }

    public GrowableIntArray() {
        this(16);
    }

    public GrowableIntArray copy() {
        return new GrowableIntArray(this);
    }

    private void assertValidOffset(int offset) {
        if (offset < 0 || offset >= this.currentLength) {
            throw new IndexOutOfBoundsException("Index: " + offset + ", Size: " + this.currentLength);
        }
    }

    private void assertValidRange(Range range) {
        if (range.getBegin() < 0L || range.getEnd() >= (long)this.currentLength) {
            throw new IndexOutOfBoundsException("range: " + range + ", array size: " + this.currentLength);
        }
    }

    public void reverse() {
        int pivotPoint = this.currentLength / 2;
        for (int i = 0; i < pivotPoint; ++i) {
            int temp = this.data[i];
            int reverseI = this.currentLength - i - 1;
            this.data[i] = this.data[reverseI];
            this.data[reverseI] = temp;
        }
    }

    public int getCurrentLength() {
        return this.currentLength;
    }

    public void append(int value) {
        this.ensureCapacity(this.currentLength + 1);
        this.data[this.currentLength++] = value;
    }

    public void append(int[] values) {
        this.ensureCapacity(this.currentLength + values.length);
        System.arraycopy(values, 0, this.data, this.currentLength, values.length);
        this.currentLength += values.length;
    }

    public void append(GrowableIntArray other) {
        this.ensureCapacity(this.currentLength + other.currentLength);
        System.arraycopy(other.data, 0, this.data, this.currentLength, other.currentLength);
        this.currentLength += other.currentLength;
    }

    public int get(int offset) {
        this.assertValidOffset(offset);
        return this.data[offset];
    }

    public void prepend(int value) {
        this.insert(0, value);
    }

    public void prepend(int[] values) {
        this.insert(0, values);
    }

    public void prepend(GrowableIntArray other) {
        this.insert(0, other);
    }

    public void replace(int offset, int value) {
        this.assertValidOffset(offset);
        this.data[offset] = value;
    }

    public void insert(int offset, int[] values) {
        this.assertValidInsertOffset(offset);
        this.ensureCapacity(this.currentLength + values.length);
        System.arraycopy(this.data, offset, this.data, offset + values.length, this.currentLength - offset);
        System.arraycopy(values, 0, this.data, offset, values.length);
        this.currentLength += values.length;
    }

    public void insert(int offset, GrowableIntArray other) {
        this.assertValidInsertOffset(offset);
        this.ensureCapacity(this.currentLength + other.currentLength);
        System.arraycopy(this.data, offset, this.data, offset + other.currentLength, this.currentLength - offset);
        System.arraycopy(other.data, 0, this.data, offset, other.currentLength);
        this.currentLength += other.currentLength;
    }

    public void insert(int offset, int value) {
        this.assertValidInsertOffset(offset);
        this.ensureCapacity(this.currentLength + 1);
        System.arraycopy(this.data, offset, this.data, offset + 1, this.currentLength - offset);
        this.data[offset] = value;
        ++this.currentLength;
    }

    private void assertValidInsertOffset(int offset) {
        if (offset != this.currentLength) {
            this.assertValidOffset(offset);
        }
    }

    public void remove(Range range) {
        this.assertValidRange(range);
        int numMoved = this.currentLength - (int)range.getBegin() - (int)range.getLength();
        if (numMoved > 0) {
            System.arraycopy(this.data, (int)range.getEnd() + 1, this.data, (int)range.getBegin(), numMoved);
        }
        this.currentLength -= (int)range.getLength();
    }

    public int remove(int offset) {
        this.assertValidOffset(offset);
        int oldValue = this.data[offset];
        int numMoved = this.currentLength - offset - 1;
        if (numMoved > 0) {
            System.arraycopy(this.data, offset + 1, this.data, offset, numMoved);
        }
        --this.currentLength;
        return oldValue;
    }

    public int getCurrentCapacity() {
        return this.data.length;
    }

    private void ensureCapacity(int minCapacity) {
        int oldCapacity = this.data.length;
        if (minCapacity > oldCapacity) {
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.data = Arrays.copyOf(this.data, newCapacity);
        }
    }

    public int[] toArray() {
        return Arrays.copyOf(this.data, this.currentLength);
    }

    public int binarySearch(int key) {
        return Arrays.binarySearch(this.data, 0, this.currentLength, key);
    }

    public boolean sortedRemove(int value) {
        int index = this.binarySearch(value);
        if (index >= 0) {
            this.remove(index);
            return true;
        }
        return false;
    }

    public int sortedInsert(int value) {
        int index = this.binarySearch(value);
        if (index < 0) {
            index = -index - 1;
        }
        this.insert(index, value);
        return index;
    }

    public void sortedInsert(int[] values) {
        if (values.length == 0) {
            return;
        }
        if (this.currentLength == 0) {
            this.append(values);
            return;
        }
        int[] newData = new int[this.data.length + values.length];
        int newCurrentLength = this.currentLength + values.length;
        int ourDataIndex = 0;
        int otherDataIndex = 0;
        int ourNextValue = this.data[0];
        int otherNextValue = values[0];
        int i = 0;
        while (ourDataIndex < this.currentLength && otherDataIndex < values.length) {
            if (ourNextValue < otherNextValue) {
                newData[i] = ourNextValue;
                if (++ourDataIndex < this.currentLength) {
                    ourNextValue = this.data[ourDataIndex];
                }
            } else {
                newData[i] = otherNextValue;
                if (++otherDataIndex < values.length) {
                    otherNextValue = values[otherDataIndex];
                }
            }
            ++i;
        }
        if (ourDataIndex < this.currentLength) {
            while (ourDataIndex < this.currentLength) {
                newData[i] = this.data[ourDataIndex];
                ++i;
                ++ourDataIndex;
            }
        } else {
            while (otherDataIndex < values.length) {
                newData[i] = values[otherDataIndex];
                ++i;
                ++otherDataIndex;
            }
        }
        this.data = newData;
        this.currentLength = newCurrentLength;
    }

    public void sort() {
        Arrays.sort(this.data, 0, this.currentLength);
    }

    public void clear() {
        this.currentLength = 0;
    }

    @Override
    public Iterator<Integer> iterator() {
        return PrimitiveArrayIterators.create(this.data, this.currentLength);
    }

    public int getCount(int value) {
        int count = 0;
        for (int i = 0; i < this.currentLength; ++i) {
            if (this.data[i] != value) continue;
            ++count;
        }
        return count;
    }

    public IntStream stream() {
        return Arrays.stream(this.data, 0, this.currentLength);
    }

    public List<Integer> toBoxedList() {
        if (this.currentLength == 0) {
            return new ArrayList<Integer>();
        }
        return ArrayUtil.asList(this.toArray());
    }

    public <E extends Throwable> void forEachIndexed(ThrowingIntIndexedIntConsumer<E> consumer) throws E {
        Objects.requireNonNull(consumer);
        for (int i = 0; i < this.currentLength; ++i) {
            consumer.accept(i, this.data[i]);
        }
    }

    public <E extends Throwable> void forEachIndexed(Range range, ThrowingIntIndexedIntConsumer<E> consumer) throws E {
        int end = (int)Math.min((long)this.currentLength, range.getEnd() + 1L);
        for (int i = (int)range.getBegin(); i < end; ++i) {
            consumer.accept(i, this.data[i]);
        }
    }
}

