/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.internal.core.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.util.streams.ThrowingIntIndexedCharConsumer;
import org.jcvi.jillion.internal.core.util.iter.PrimitiveArrayIterators;

public final class GrowableCharArray
implements Iterable<Character> {
    private int currentLength = 0;
    private char[] data;

    public GrowableCharArray(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity should be >= 0 :" + initialCapacity);
        }
        this.data = new char[initialCapacity];
    }

    public GrowableCharArray(Collection<Character> chars) {
        this.data = new char[chars.size()];
        int index = 0;
        for (Character i : chars) {
            this.data[index] = i.charValue();
            ++index;
        }
        this.currentLength = this.data.length;
    }

    public GrowableCharArray(char[] chars) {
        this.data = Arrays.copyOf(chars, chars.length);
        this.currentLength = this.data.length;
    }

    private GrowableCharArray(GrowableCharArray copy) {
        this.data = Arrays.copyOf(copy.data, copy.data.length);
        this.currentLength = copy.currentLength;
    }

    public GrowableCharArray copy() {
        return new GrowableCharArray(this);
    }

    private void assertValidOffset(int offset) {
        if (offset < 0 || offset >= this.currentLength) {
            throw new IndexOutOfBoundsException("Index: " + offset + ", Size: " + this.currentLength);
        }
    }

    private void assertValidRange(Range range) {
        if (range.getBegin() < 0L || range.getEnd() >= (long)this.currentLength) {
            throw new IndexOutOfBoundsException("range: " + range + ", array size: " + this.currentLength);
        }
    }

    public void reverse() {
        int pivotPoint = this.currentLength / 2;
        for (int i = 0; i < pivotPoint; ++i) {
            char temp = this.data[i];
            int reverseI = this.currentLength - i - 1;
            this.data[i] = this.data[reverseI];
            this.data[reverseI] = temp;
        }
    }

    public int getCurrentLength() {
        return this.currentLength;
    }

    public void append(char value) {
        this.ensureCapacity(this.currentLength + 1);
        this.data[this.currentLength++] = value;
    }

    public void append(char[] values) {
        this.ensureCapacity(this.currentLength + values.length);
        System.arraycopy(values, 0, this.data, this.currentLength, values.length);
        this.currentLength += values.length;
    }

    public void append(GrowableCharArray other) {
        this.ensureCapacity(this.currentLength + other.currentLength);
        System.arraycopy(other.data, 0, this.data, this.currentLength, other.currentLength);
        this.currentLength += other.currentLength;
    }

    public char get(int offset) {
        this.assertValidOffset(offset);
        return this.data[offset];
    }

    public void prepend(char value) {
        this.insert(0, value);
    }

    public void prepend(char[] values) {
        this.insert(0, values);
    }

    public void prepend(GrowableCharArray other) {
        this.insert(0, other);
    }

    public void replace(int offset, char value) {
        this.assertValidOffset(offset);
        this.data[offset] = value;
    }

    public void insert(int offset, char[] values) {
        this.assertValidInsertOffset(offset);
        this.ensureCapacity(this.currentLength + values.length);
        System.arraycopy(this.data, offset, this.data, offset + values.length, this.currentLength - offset);
        System.arraycopy(values, 0, this.data, offset, values.length);
        this.currentLength += values.length;
    }

    public void insert(int offset, GrowableCharArray other) {
        this.assertValidInsertOffset(offset);
        this.ensureCapacity(this.currentLength + other.currentLength);
        System.arraycopy(this.data, offset, this.data, offset + other.currentLength, this.currentLength - offset);
        System.arraycopy(other.data, 0, this.data, offset, other.currentLength);
        this.currentLength += other.currentLength;
    }

    public void insert(int offset, char value) {
        this.assertValidInsertOffset(offset);
        this.ensureCapacity(this.currentLength + 1);
        System.arraycopy(this.data, offset, this.data, offset + 1, this.currentLength - offset);
        this.data[offset] = value;
        ++this.currentLength;
    }

    private void assertValidInsertOffset(int offset) {
        if (offset != this.currentLength) {
            this.assertValidOffset(offset);
        }
    }

    public void remove(Range range) {
        this.assertValidRange(range);
        int numMoved = this.currentLength - (int)range.getBegin() - (int)range.getLength();
        if (numMoved > 0) {
            System.arraycopy(this.data, (int)range.getEnd() + 1, this.data, (int)range.getBegin(), numMoved);
        }
        this.currentLength -= (int)range.getLength();
    }

    public char remove(int offset) {
        this.assertValidOffset(offset);
        char oldValue = this.data[offset];
        int numMoved = this.currentLength - offset - 1;
        if (numMoved > 0) {
            System.arraycopy(this.data, offset + 1, this.data, offset, numMoved);
        }
        --this.currentLength;
        return oldValue;
    }

    public int getCurrentCapacity() {
        return this.data.length;
    }

    private void ensureCapacity(int minCapacity) {
        int oldCapacity = this.data.length;
        if (minCapacity > oldCapacity) {
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.data = Arrays.copyOf(this.data, newCapacity);
        }
    }

    public char[] toArray() {
        return Arrays.copyOf(this.data, this.currentLength);
    }

    public int binarySearch(char key) {
        return Arrays.binarySearch(this.data, 0, this.currentLength, key);
    }

    public boolean sortedRemove(char value) {
        int index = this.binarySearch(value);
        if (index >= 0) {
            this.remove(index);
            return true;
        }
        return false;
    }

    public int sortedInsert(char value) {
        int index = this.binarySearch(value);
        if (index < 0) {
            index = -index - 1;
        }
        this.insert(index, value);
        return index;
    }

    public void sort() {
        Arrays.sort(this.data, 0, this.currentLength);
    }

    public void clear() {
        this.currentLength = 0;
    }

    @Override
    public Iterator<Character> iterator() {
        return PrimitiveArrayIterators.create(this.data, this.currentLength);
    }

    public void sortedInsert(char[] values) {
        if (values.length == 0) {
            return;
        }
        if (this.currentLength == 0) {
            this.append(values);
            return;
        }
        char[] newData = new char[this.data.length + values.length];
        int newCurrentLength = this.currentLength + values.length;
        int ourDataIndex = 0;
        int otherDataIndex = 0;
        char ourNextValue = this.data[0];
        char otherNextValue = values[0];
        int i = 0;
        while (ourDataIndex < this.currentLength && otherDataIndex < values.length) {
            if (ourNextValue < otherNextValue) {
                newData[i] = ourNextValue;
                if (++ourDataIndex < this.currentLength) {
                    ourNextValue = this.data[ourDataIndex];
                }
            } else {
                newData[i] = otherNextValue;
                if (++otherDataIndex < values.length) {
                    otherNextValue = values[otherDataIndex];
                }
            }
            ++i;
        }
        if (ourDataIndex < this.currentLength) {
            while (ourDataIndex < this.currentLength) {
                newData[i] = this.data[ourDataIndex];
                ++i;
                ++ourDataIndex;
            }
        } else {
            while (otherDataIndex < values.length) {
                newData[i] = values[otherDataIndex];
                ++i;
                ++otherDataIndex;
            }
        }
        this.data = newData;
        this.currentLength = newCurrentLength;
    }

    public int getCount(char value) {
        int count = 0;
        for (int i = 0; i < this.currentLength; ++i) {
            if (this.data[i] != value) continue;
            ++count;
        }
        return count;
    }

    public String createNewString() {
        return new String(this.data, 0, this.currentLength);
    }

    public <E extends Throwable> void forEachIndexed(ThrowingIntIndexedCharConsumer<E> consumer) throws E {
        Objects.requireNonNull(consumer);
        for (int i = 0; i < this.currentLength; ++i) {
            consumer.accept(i, this.data[i]);
        }
    }

    public <E extends Throwable> void forEachIndexed(Range range, ThrowingIntIndexedCharConsumer<E> consumer) throws E {
        int end = (int)Math.min((long)this.currentLength, range.getEnd() + 1L);
        for (int i = (int)range.getBegin(); i < end; ++i) {
            consumer.accept(i, this.data[i]);
        }
    }
}

