/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.internal.core.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.stream.IntStream;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.util.streams.ThrowingIntIndexedByteConsumer;
import org.jcvi.jillion.internal.core.util.iter.PrimitiveArrayIterators;

public final class GrowableByteArray
implements Iterable<Byte> {
    private int currentLength = 0;
    private byte[] data;

    public GrowableByteArray() {
        this(16);
    }

    public GrowableByteArray(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity should be >= 0 :" + initialCapacity);
        }
        this.data = new byte[initialCapacity];
    }

    public GrowableByteArray(Collection<Byte> bytes) {
        this.data = new byte[bytes.size()];
        int index = 0;
        for (Byte i : bytes) {
            this.data[index] = i;
            ++index;
        }
        this.currentLength = this.data.length;
    }

    public GrowableByteArray(byte[] bytes) {
        this.data = Arrays.copyOf(bytes, bytes.length);
        this.currentLength = this.data.length;
    }

    private GrowableByteArray(GrowableByteArray copy) {
        this.data = Arrays.copyOf(copy.data, copy.data.length);
        this.currentLength = copy.currentLength;
    }

    public GrowableByteArray copy() {
        return new GrowableByteArray(this);
    }

    private void assertValidOffset(int offset) {
        if (offset < 0 || offset >= this.currentLength) {
            throw new IndexOutOfBoundsException("Index: " + offset + ", Size: " + this.currentLength);
        }
    }

    private void assertValidRange(Range range) {
        if (range.getBegin() < 0L || range.getEnd() >= (long)this.currentLength) {
            throw new IndexOutOfBoundsException("range: " + range + ", array size: " + this.currentLength);
        }
    }

    public void reverse() {
        int pivotPoint = this.currentLength / 2;
        for (int i = 0; i < pivotPoint; ++i) {
            byte temp = this.data[i];
            int reverseI = this.currentLength - i - 1;
            this.data[i] = this.data[reverseI];
            this.data[reverseI] = temp;
        }
    }

    public int getCurrentLength() {
        return this.currentLength;
    }

    public void append(byte value) {
        this.ensureCapacity(this.currentLength + 1);
        this.data[this.currentLength++] = value;
    }

    public void append(byte[] values) {
        this.ensureCapacity(this.currentLength + values.length);
        System.arraycopy(values, 0, this.data, this.currentLength, values.length);
        this.currentLength += values.length;
    }

    public void append(GrowableByteArray other) {
        this.ensureCapacity(this.currentLength + other.currentLength);
        System.arraycopy(other.data, 0, this.data, this.currentLength, other.currentLength);
        this.currentLength += other.currentLength;
    }

    public byte get(int offset) {
        this.assertValidOffset(offset);
        return this.data[offset];
    }

    public void prepend(byte value) {
        this.insert(0, value);
    }

    public void prepend(byte[] values) {
        this.insert(0, values);
    }

    public void prepend(GrowableByteArray other) {
        this.insert(0, other);
    }

    public void replace(int offset, byte value) {
        this.assertValidOffset(offset);
        this.data[offset] = value;
    }

    public void insert(int offset, byte[] values) {
        this.assertValidInsertOffset(offset);
        this.ensureCapacity(this.currentLength + values.length);
        System.arraycopy(this.data, offset, this.data, offset + values.length, this.currentLength - offset);
        System.arraycopy(values, 0, this.data, offset, values.length);
        this.currentLength += values.length;
    }

    public void insert(int offset, GrowableByteArray other) {
        this.assertValidInsertOffset(offset);
        this.ensureCapacity(this.currentLength + other.currentLength);
        System.arraycopy(this.data, offset, this.data, offset + other.currentLength, this.currentLength - offset);
        System.arraycopy(other.data, 0, this.data, offset, other.currentLength);
        this.currentLength += other.currentLength;
    }

    public void insert(int offset, byte value) {
        this.assertValidInsertOffset(offset);
        this.ensureCapacity(this.currentLength + 1);
        System.arraycopy(this.data, offset, this.data, offset + 1, this.currentLength - offset);
        this.data[offset] = value;
        ++this.currentLength;
    }

    private void assertValidInsertOffset(int offset) {
        if (offset != this.currentLength) {
            this.assertValidOffset(offset);
        }
    }

    public void remove(Range range) {
        this.assertValidRange(range);
        int numMoved = this.currentLength - (int)range.getBegin() - (int)range.getLength();
        if (numMoved > 0) {
            System.arraycopy(this.data, (int)range.getEnd() + 1, this.data, (int)range.getBegin(), numMoved);
        }
        this.currentLength -= (int)range.getLength();
    }

    public byte remove(int offset) {
        this.assertValidOffset(offset);
        byte oldValue = this.data[offset];
        int numMoved = this.currentLength - offset - 1;
        if (numMoved > 0) {
            System.arraycopy(this.data, offset + 1, this.data, offset, numMoved);
        }
        --this.currentLength;
        return oldValue;
    }

    public int getCurrentCapacity() {
        return this.data.length;
    }

    private void ensureCapacity(int minCapacity) {
        int oldCapacity = this.data.length;
        if (minCapacity > oldCapacity) {
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.data = Arrays.copyOf(this.data, newCapacity);
        }
    }

    public byte[] toArray() {
        return Arrays.copyOf(this.data, this.currentLength);
    }

    public int binarySearch(byte key) {
        return Arrays.binarySearch(this.data, 0, this.currentLength, key);
    }

    public boolean sortedRemove(byte value) {
        int index = this.binarySearch(value);
        if (index >= 0) {
            this.remove(index);
            return true;
        }
        return false;
    }

    public int sortedInsert(byte value) {
        int index = this.binarySearch(value);
        if (index < 0) {
            index = -index - 1;
        }
        this.insert(index, value);
        return index;
    }

    public void sort() {
        Arrays.sort(this.data, 0, this.currentLength);
    }

    public void clear() {
        this.currentLength = 0;
    }

    @Override
    public Iterator<Byte> iterator() {
        return PrimitiveArrayIterators.create(this.data, this.currentLength);
    }

    public GrowableByteArray subArray(Range range) {
        if (range == null) {
            throw new NullPointerException("range can not be null");
        }
        int start = (int)range.getBegin();
        int end = (int)range.getEnd() + 1;
        if (start < 0) {
            start = 0;
        }
        if (end > this.currentLength) {
            end = this.currentLength;
        }
        return new GrowableByteArray(Arrays.copyOfRange(this.data, start, end));
    }

    public void sortedInsert(byte[] values) {
        if (values.length == 0) {
            return;
        }
        if (this.currentLength == 0) {
            this.append(values);
            return;
        }
        byte[] newData = new byte[this.data.length + values.length];
        int newCurrentLength = this.currentLength + values.length;
        int ourDataIndex = 0;
        int otherDataIndex = 0;
        byte ourNextValue = this.data[0];
        byte otherNextValue = values[0];
        int i = 0;
        while (ourDataIndex < this.currentLength && otherDataIndex < values.length) {
            if (ourNextValue < otherNextValue) {
                newData[i] = ourNextValue;
                if (++ourDataIndex < this.currentLength) {
                    ourNextValue = this.data[ourDataIndex];
                }
            } else {
                newData[i] = otherNextValue;
                if (++otherDataIndex < values.length) {
                    otherNextValue = values[otherDataIndex];
                }
            }
            ++i;
        }
        if (ourDataIndex < this.currentLength) {
            while (ourDataIndex < this.currentLength) {
                newData[i] = this.data[ourDataIndex];
                ++i;
                ++ourDataIndex;
            }
        } else {
            while (otherDataIndex < values.length) {
                newData[i] = values[otherDataIndex];
                ++i;
                ++otherDataIndex;
            }
        }
        this.data = newData;
        this.currentLength = newCurrentLength;
    }

    public int getCount(byte value) {
        int count = 0;
        for (int i = 0; i < this.currentLength; ++i) {
            if (this.data[i] != value) continue;
            ++count;
        }
        return count;
    }

    public IntStream stream() {
        int[] copy = new int[this.currentLength];
        for (int i = 0; i < this.currentLength; ++i) {
            copy[i] = this.data[i];
        }
        return Arrays.stream(copy, 0, this.currentLength);
    }

    public <E extends Throwable> void forEachIndexed(ThrowingIntIndexedByteConsumer<E> consumer) throws E {
        for (int i = 0; i < this.currentLength; ++i) {
            consumer.accept(i, this.data[i]);
        }
    }

    public <E extends Throwable> void forEachIndexed(Range range, ThrowingIntIndexedByteConsumer<E> consumer) throws E {
        int end = (int)Math.min((long)this.currentLength, range.getEnd() + 1L);
        for (int i = (int)range.getBegin(); i < end; ++i) {
            consumer.accept(i, this.data[i]);
        }
    }
}

