/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.internal.core.util;

import java.util.Arrays;
import java.util.BitSet;
import java.util.stream.IntStream;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.util.streams.ThrowingIntIndexedBooleanConsumer;
import org.jcvi.jillion.internal.core.util.GrowableIntArray;

public final class GrowableBitArray {
    private int currentLength = 0;
    private boolean[] data;

    public GrowableBitArray(int initialCapacity) {
        if (initialCapacity <= 0) {
            throw new IllegalArgumentException("initial capacity should be > 0 :" + initialCapacity);
        }
        this.data = new boolean[initialCapacity];
    }

    public GrowableBitArray(BitSet bs) {
        this.data = new boolean[bs.length()];
        this.currentLength = this.data.length;
        int i = bs.nextSetBit(0);
        while (i >= 0) {
            this.data[i] = true;
            if (i == Integer.MAX_VALUE) break;
            i = bs.nextSetBit(i + 1);
        }
    }

    public GrowableBitArray(boolean[] bytes) {
        this.data = Arrays.copyOf(bytes, bytes.length);
        this.currentLength = this.data.length;
    }

    private GrowableBitArray(GrowableBitArray copy) {
        this.data = Arrays.copyOf(copy.data, copy.data.length);
        this.currentLength = copy.currentLength;
    }

    public GrowableBitArray copy() {
        return new GrowableBitArray(this);
    }

    private void assertValidOffset(int offset) {
        if (offset < 0 || offset >= this.currentLength) {
            throw new IndexOutOfBoundsException("Index: " + offset + ", Size: " + this.currentLength);
        }
    }

    private void assertValidRange(Range range) {
        if (range.getBegin() < 0L || range.getEnd() >= (long)this.currentLength) {
            throw new IndexOutOfBoundsException("range: " + range + ", array size: " + this.currentLength);
        }
    }

    public void reverse() {
        int pivotPoint = this.currentLength / 2;
        for (int i = 0; i < pivotPoint; ++i) {
            boolean temp = this.data[i];
            int reverseI = this.currentLength - i - 1;
            this.data[i] = this.data[reverseI];
            this.data[reverseI] = temp;
        }
    }

    public int getCurrentLength() {
        return this.currentLength;
    }

    public void append(boolean value) {
        this.ensureCapacity(this.currentLength + 1);
        this.data[this.currentLength++] = value;
    }

    public void append(boolean[] values) {
        this.ensureCapacity(this.currentLength + values.length);
        System.arraycopy(values, 0, this.data, this.currentLength, values.length);
        this.currentLength += values.length;
    }

    public void append(GrowableBitArray other) {
        this.ensureCapacity(this.currentLength + other.currentLength);
        System.arraycopy(other.data, 0, this.data, this.currentLength, other.currentLength);
        this.currentLength += other.currentLength;
    }

    public boolean get(int offset) {
        this.assertValidOffset(offset);
        return this.data[offset];
    }

    public void prepend(boolean value) {
        this.insert(0, value);
    }

    public void prepend(boolean[] values) {
        this.insert(0, values);
    }

    public void prepend(GrowableBitArray other) {
        this.insert(0, other);
    }

    public void replace(int offset, boolean value) {
        this.assertValidOffset(offset);
        this.data[offset] = value;
    }

    public void insert(int offset, boolean[] values) {
        this.assertValidInsertOffset(offset);
        this.ensureCapacity(this.currentLength + values.length);
        System.arraycopy(this.data, offset, this.data, offset + values.length, this.currentLength - offset);
        System.arraycopy(values, 0, this.data, offset, values.length);
        this.currentLength += values.length;
    }

    public void insert(int offset, GrowableBitArray other) {
        this.assertValidInsertOffset(offset);
        this.ensureCapacity(this.currentLength + other.currentLength);
        System.arraycopy(this.data, offset, this.data, offset + other.currentLength, this.currentLength - offset);
        System.arraycopy(other.data, 0, this.data, offset, other.currentLength);
        this.currentLength += other.currentLength;
    }

    public void insert(int offset, boolean value) {
        this.assertValidInsertOffset(offset);
        this.ensureCapacity(this.currentLength + 1);
        System.arraycopy(this.data, offset, this.data, offset + 1, this.currentLength - offset);
        this.data[offset] = value;
        ++this.currentLength;
    }

    private void assertValidInsertOffset(int offset) {
        if (offset != this.currentLength) {
            this.assertValidOffset(offset);
        }
    }

    public void remove(Range range) {
        this.assertValidRange(range);
        int numMoved = this.currentLength - (int)range.getBegin() - (int)range.getLength();
        if (numMoved > 0) {
            System.arraycopy(this.data, (int)range.getEnd() + 1, this.data, (int)range.getBegin(), numMoved);
        }
        this.currentLength -= (int)range.getLength();
    }

    public boolean remove(int offset) {
        this.assertValidOffset(offset);
        boolean oldValue = this.data[offset];
        int numMoved = this.currentLength - offset - 1;
        if (numMoved > 0) {
            System.arraycopy(this.data, offset + 1, this.data, offset, numMoved);
        }
        --this.currentLength;
        return oldValue;
    }

    public void ensureCapacity(int minCapacity) {
        int oldCapacity = this.data.length;
        if (minCapacity > oldCapacity) {
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.data = Arrays.copyOf(this.data, newCapacity);
        }
    }

    public boolean[] toArray() {
        return Arrays.copyOf(this.data, this.currentLength);
    }

    public IntStream onBitsAsStream() {
        GrowableIntArray ons = new GrowableIntArray();
        this.forEachIndexed((i, v) -> {
            if (v) {
                ons.append(i);
            }
        });
        return ons.stream();
    }

    public BitSet asBitSet() {
        BitSet bs = new BitSet(this.currentLength);
        this.onBitsAsStream().forEach(bs::set);
        return bs;
    }

    public <E extends Throwable> void forEachIndexed(ThrowingIntIndexedBooleanConsumer<E> consumer) throws E {
        for (int i = 0; i < this.currentLength; ++i) {
            consumer.accept(i, this.data[i]);
        }
    }

    public <E extends Throwable> void forEachIndexed(Range range, ThrowingIntIndexedBooleanConsumer<E> consumer) throws E {
        int end = (int)Math.min((long)this.currentLength, range.getEnd() + 1L);
        for (int i = (int)range.getBegin(); i < end; ++i) {
            consumer.accept(i, this.data[i]);
        }
    }
}

