/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.internal.core.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jcvi.jillion.core.util.MapUtil;

public final class Caches {
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    public static final int DEFAULT_CAPACITY = 16;

    private Caches() {
    }

    public static <K, V> Map<K, V> createLRUCache() {
        return Caches.createLRUCache(16);
    }

    public static <K, V> Map<K, V> createLRUCache(int maxcapacity) {
        return new LRUCache(maxcapacity);
    }

    public static <K, V> Map<K, V> createMap() {
        return Caches.createMap(16);
    }

    public static <K, V> Map<K, V> createMap(int initialSize) {
        return new LinkedHashMap(initialSize);
    }

    public static <K, V> Map<K, V> createSoftReferencedValueLRUCache() {
        return Caches.createSoftReferencedValueLRUCache(16);
    }

    public static <K, V> Map<K, V> createSoftReferencedValueCache() {
        return Caches.createSoftReferencedValueCache(16);
    }

    public static <K, V> Map<K, V> createSoftReferencedValueCache(int initialCapacity) {
        return new SoftReferenceCache(initialCapacity);
    }

    public static <K, V> Map<K, V> createSoftReferencedValueLRUCache(int maxSize) {
        return new SoftReferenceLRUCache(maxSize);
    }

    public static <K, V> Map<K, V> createWeakReferencedValueLRUCache() {
        return Caches.createWeakReferencedValueLRUCache(16);
    }

    public static <K, V> Map<K, V> createWeakReferencedValueLRUCache(int maxSize) {
        return new WeakReferenceLRUCache(maxSize);
    }

    public static <K, V> Map<K, V> createWeakReferencedValueCache() {
        return Caches.createWeakReferencedValueLRUCache(16);
    }

    public static <K, V> Map<K, V> createWeakReferencedValueCache(int maxSize) {
        return new WeakReferenceCache(maxSize);
    }

    private static <K, V> Map<K, V> createNonLRUMap(int maxSize) {
        return new LinkedHashMap(maxSize);
    }

    private static class WeakReferenceCache<K, V>
    extends AbstractReferencedCache<K, V, WeakReference<V>> {
        public WeakReferenceCache(int initialCapacity) {
            super(Caches.createNonLRUMap(initialCapacity), initialCapacity);
        }

        @Override
        protected WeakReference<V> createReferenceFor(V value, ReferenceQueue<V> referenceQueue) {
            return new WeakReference<V>(value, referenceQueue);
        }
    }

    private static class WeakReferenceLRUCache<K, V>
    extends AbstractReferencedCache<K, V, WeakReference<V>> {
        public WeakReferenceLRUCache(int maxSize) {
            super(new LRUCache(maxSize, 0.75f), maxSize);
        }

        @Override
        protected WeakReference<V> createReferenceFor(V value, ReferenceQueue<V> referenceQueue) {
            return new WeakReference<V>(value, referenceQueue);
        }
    }

    private static class SoftReferenceLRUCache<K, V>
    extends AbstractReferencedCache<K, V, SoftReference<V>> {
        public SoftReferenceLRUCache(int maxSize) {
            super(new LRUCache(maxSize, 0.75f), maxSize);
        }

        @Override
        protected SoftReference<V> createReferenceFor(V value, ReferenceQueue<V> referenceQueue) {
            return new SoftReference<V>(value, referenceQueue);
        }
    }

    private static class SoftReferenceCache<K, V>
    extends AbstractReferencedCache<K, V, SoftReference<V>> {
        public SoftReferenceCache(int initialCapacity) {
            super(Caches.createNonLRUMap(initialCapacity), initialCapacity);
        }

        @Override
        protected SoftReference<V> createReferenceFor(V value, ReferenceQueue<V> referenceQueue) {
            return new SoftReference<V>(value, referenceQueue);
        }
    }

    private static abstract class AbstractReferencedCache<K, V, R extends Reference<V>>
    extends AbstractMap<K, V> {
        private final Map<K, R> cache;
        private final ReferenceQueue<V> referenceQueue = new ReferenceQueue();
        private final Map<Reference<? extends V>, K> referenceKeyMap;

        AbstractReferencedCache(Map<K, R> map, int initialCapacity) {
            this.cache = map;
            int mapSize = MapUtil.computeMinHashMapSizeWithoutRehashing(initialCapacity);
            this.referenceKeyMap = new HashMap<Reference<? extends V>, K>(mapSize);
        }

        protected abstract R createReferenceFor(V var1, ReferenceQueue<V> var2);

        private synchronized void removeAnyGarbageCollectedEntries() {
            Reference<V> collectedReference;
            while ((collectedReference = this.referenceQueue.poll()) != null) {
                K key = this.referenceKeyMap.remove(collectedReference);
                this.cache.remove(key);
            }
        }

        @Override
        public synchronized int size() {
            this.removeAnyGarbageCollectedEntries();
            return this.cache.size();
        }

        @Override
        public synchronized boolean isEmpty() {
            this.removeAnyGarbageCollectedEntries();
            return this.cache.isEmpty();
        }

        @Override
        public synchronized boolean containsKey(Object key) {
            this.removeAnyGarbageCollectedEntries();
            return this.cache.containsKey(key);
        }

        @Override
        public synchronized V get(Object key) {
            this.removeAnyGarbageCollectedEntries();
            Reference softReference = (Reference)this.cache.get(key);
            return this.getReference(softReference);
        }

        @Override
        public synchronized V put(K key, V value) {
            this.removeAnyGarbageCollectedEntries();
            R newReference = this.createReferenceFor(value, this.referenceQueue);
            Reference oldReference = (Reference)this.cache.put(key, newReference);
            this.referenceKeyMap.put((Reference<K>)newReference, (R)key);
            return this.getReference(oldReference);
        }

        @Override
        public synchronized V remove(Object key) {
            this.removeAnyGarbageCollectedEntries();
            Reference oldReference = (Reference)this.cache.remove(key);
            this.referenceKeyMap.remove(oldReference);
            return this.getReference(oldReference);
        }

        private V getReference(R ref) {
            if (ref == null) {
                return null;
            }
            return (V)((Reference)ref).get();
        }

        @Override
        public synchronized void clear() {
            this.removeAnyGarbageCollectedEntries();
            this.cache.clear();
            this.referenceKeyMap.clear();
        }

        @Override
        public synchronized Set<K> keySet() {
            this.removeAnyGarbageCollectedEntries();
            return this.cache.keySet();
        }

        @Override
        public synchronized Collection<V> values() {
            this.removeAnyGarbageCollectedEntries();
            Collection<R> softValues = this.cache.values();
            ArrayList actualValues = new ArrayList(softValues.size());
            for (Reference softValue : softValues) {
                if (softValue == null) continue;
                actualValues.add(softValue.get());
            }
            return actualValues;
        }

        @Override
        public synchronized Set<Map.Entry<K, V>> entrySet() {
            this.removeAnyGarbageCollectedEntries();
            LinkedHashSet<Map.Entry<K, V>> result = new LinkedHashSet<Map.Entry<K, V>>();
            for (final Map.Entry<K, R> entry : this.cache.entrySet()) {
                final K key = entry.getKey();
                final Object value = ((Reference)entry.getValue()).get();
                if (value == null) continue;
                result.add(new Map.Entry<K, V>(){

                    @Override
                    public K getKey() {
                        return key;
                    }

                    @Override
                    public V getValue() {
                        return value;
                    }

                    @Override
                    public V setValue(V newValue) {
                        entry.setValue(this.createReferenceFor(newValue, referenceQueue));
                        return value;
                    }
                });
            }
            return result;
        }
    }

    private static final class LRUCache<K, V>
    extends LinkedHashMap<K, V> {
        private static final long serialVersionUID = -9015747210650112857L;
        private final int maxAllowedSize;

        protected LRUCache(int maxAllowedSize, float loadFactor) {
            super(MapUtil.computeMinHashMapSizeWithoutRehashing(maxAllowedSize, loadFactor), loadFactor, true);
            this.maxAllowedSize = maxAllowedSize;
        }

        protected LRUCache(int maxAllowedSize) {
            this(maxAllowedSize, 0.75f);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > this.maxAllowedSize;
        }
    }
}

