/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.internal.core.util;

import java.util.AbstractQueue;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import java.util.PriorityQueue;

public class BoundedPriorityQueue<E>
extends AbstractQueue<E> {
    private final int maxSize;
    private final Comparator<? super E> comparator;
    private final PriorityQueue<E> delegate;

    public static <E extends Comparable<? super E>> BoundedPriorityQueue<E> create(int maxSize) {
        return new BoundedPriorityQueue(maxSize, Comparator.naturalOrder());
    }

    public static <E> BoundedPriorityQueue<E> create(int maxSize, Comparator<? super E> comparator) {
        return new BoundedPriorityQueue<E>(maxSize, comparator);
    }

    private BoundedPriorityQueue(int maxSize, Comparator<? super E> comparator) {
        if (maxSize < 1) {
            throw new IllegalArgumentException("max size must be >= 1");
        }
        Objects.requireNonNull(comparator);
        this.comparator = comparator;
        this.delegate = new PriorityQueue<E>(this.comparator);
        this.maxSize = maxSize;
    }

    @Override
    public boolean offer(E e) {
        if (this.size() >= this.maxSize) {
            E peek = this.peek();
            if (this.comparator.compare(e, peek) > 0) {
                this.poll();
            } else {
                return true;
            }
        }
        return this.delegate.offer(e);
    }

    @Override
    public E poll() {
        return this.delegate.poll();
    }

    @Override
    public E peek() {
        return this.delegate.peek();
    }

    @Override
    public Iterator<E> iterator() {
        return this.delegate.iterator();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }
}

