/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.internal.core.util;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;

public final class ArrayUtil {
    public static List<Integer> asList(int[] array) {
        return new IntArrayList(array);
    }

    private ArrayUtil() {
    }

    private static final class IntArrayList
    extends AbstractList<Integer>
    implements RandomAccess {
        private final int[] array;

        private IntArrayList(int[] array) {
            this.array = array;
        }

        @Override
        public Integer get(int index) {
            return this.array[index];
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public Integer set(int index, Integer element) {
            Integer old = this.array[index];
            this.array[index] = element;
            return old;
        }

        @Override
        public int indexOf(Object o) {
            if (o == null) {
                return -1;
            }
            if (!(o instanceof Integer)) {
                return -1;
            }
            int val = (Integer)o;
            for (int i = 0; i < this.array.length; ++i) {
                if (val != this.array[i]) continue;
                return i;
            }
            return -1;
        }

        @Override
        public boolean contains(Object o) {
            return this.indexOf(o) != -1;
        }

        @Override
        public boolean equals(Object o) {
            int currentOffset;
            if (o == this) {
                return true;
            }
            if (!(o instanceof List)) {
                return false;
            }
            ListIterator e2 = ((List)o).listIterator();
            for (currentOffset = 0; currentOffset < this.array.length && e2.hasNext(); ++currentOffset) {
                Object o2 = e2.next();
                if (!(o2 instanceof Integer)) {
                    return false;
                }
                if (this.array[currentOffset] == (Integer)o2) continue;
                return false;
            }
            return currentOffset >= this.array.length && !e2.hasNext();
        }

        @Override
        public int hashCode() {
            return Arrays.hashCode(this.array);
        }
    }
}

