/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.internal.core.residue;

import org.jcvi.jillion.core.residue.Residue;
import org.jcvi.jillion.core.residue.ResidueSequence;
import org.jcvi.jillion.core.residue.ResidueSequenceBuilder;

public abstract class AbstractResidueSequence<R extends Residue, T extends ResidueSequence<R, T, B>, B extends ResidueSequenceBuilder<R, T>>
implements ResidueSequence<R, T, B> {
    @Override
    public long getUngappedLength() {
        return this.getLength() - (long)this.getNumberOfGaps();
    }

    @Override
    public int getNumberOfGapsUntil(int gappedValidRangeIndex) {
        int numberOfGaps = 0;
        for (Integer gapIndex : this.getGapOffsets()) {
            if (gapIndex > gappedValidRangeIndex) break;
            ++numberOfGaps;
        }
        return numberOfGaps;
    }

    private int computeNumberOfInclusiveGapsInUngappedValidRangeUntil(int ungappedValidRangeIndex) {
        int numberOfGaps = 0;
        for (Integer gapIndex : this.getGapOffsets()) {
            if (gapIndex > ungappedValidRangeIndex + numberOfGaps) break;
            ++numberOfGaps;
        }
        return numberOfGaps;
    }

    @Override
    public int getUngappedOffsetFor(int gappedOffset) {
        this.checkPositiveOffset(gappedOffset);
        long length = this.getLength();
        if ((long)gappedOffset > length - 1L) {
            throw new IndexOutOfBoundsException("gapped offset " + gappedOffset + " extends beyond sequence length " + length);
        }
        return gappedOffset - this.getNumberOfGapsUntil(gappedOffset);
    }

    @Override
    public int getGappedOffsetFor(int ungappedOffset) {
        this.checkPositiveOffset(ungappedOffset);
        long length = this.getLength();
        int gappedOffset = ungappedOffset + this.computeNumberOfInclusiveGapsInUngappedValidRangeUntil(ungappedOffset);
        if ((long)gappedOffset > length - 1L) {
            throw new IndexOutOfBoundsException(String.format("ungapped offset %d (gapped offset %d extends beyond sequence length %d", ungappedOffset, gappedOffset, length));
        }
        return gappedOffset;
    }

    private void checkPositiveOffset(int offset) {
        if (offset < 0) {
            throw new IndexOutOfBoundsException("offset can not be negative");
        }
    }
}

