/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.internal.core.io;

import java.nio.ByteBuffer;
import org.jcvi.jillion.core.io.IOUtil;

public enum ValueSizeStrategy {
    NONE{

        @Override
        public int getNext(ByteBuffer buf) {
            throw new IllegalArgumentException("can not call getNext()");
        }

        @Override
        public void put(ByteBuffer buf, int value) {
            throw new IllegalArgumentException("can not call put()");
        }

        @Override
        public int getNumberOfBytesPerValue() {
            return 0;
        }
    }
    ,
    BYTE{

        @Override
        public int getNumberOfBytesPerValue() {
            return 1;
        }

        @Override
        public int getNext(ByteBuffer buf) {
            return IOUtil.toUnsignedByte(buf.get());
        }

        @Override
        public void put(ByteBuffer buf, int value) {
            buf.put((byte)value);
        }
    }
    ,
    SHORT{

        @Override
        public int getNumberOfBytesPerValue() {
            return 2;
        }

        @Override
        public int getNext(ByteBuffer buf) {
            return IOUtil.toUnsignedShort(buf.getShort());
        }

        @Override
        public void put(ByteBuffer buf, int value) {
            buf.putShort((short)value);
        }
    }
    ,
    INTEGER{

        @Override
        public int getNumberOfBytesPerValue() {
            return 4;
        }

        @Override
        public int getNext(ByteBuffer buf) {
            return buf.getInt();
        }

        @Override
        public void put(ByteBuffer buf, int value) {
            buf.putInt(value);
        }
    };


    public abstract int getNext(ByteBuffer var1);

    public abstract void put(ByteBuffer var1, int var2);

    public abstract int getNumberOfBytesPerValue();

    public static ValueSizeStrategy getStrategyFor(int largestValue) {
        if (largestValue <= 255) {
            return BYTE;
        }
        if (largestValue <= 65535) {
            return SHORT;
        }
        return INTEGER;
    }
}

