/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.internal.core.io;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.internal.core.io.LineParser;
import org.jcvi.jillion.internal.core.io.RandomAccessFileInputStream;
import org.jcvi.jillion.internal.core.util.FIFOQueue;
import org.jcvi.jillion.internal.core.util.GrowableCharArray;

public final class TextLineParser
implements LineParser {
    private static final int INITIAL_LINE_CAPACITY = 200;
    private static final int NOT_SET = -2;
    private static final int EOF = -1;
    private static final char LF = '\n';
    private static final char CR = '\r';
    private final InputStream in;
    private final Object endOfFile = new Object();
    private final FIFOQueue<Object> nextQueue = new FIFOQueue();
    boolean doneFile = false;
    private long position;
    private int numberOfBytesInNextLine;
    private int pushedBackValue = -2;

    public TextLineParser(File f) throws IOException {
        this(new BufferedInputStream(new FileInputStream(f)));
    }

    public TextLineParser(File samFile, long initialPosition) throws IOException {
        this.position = initialPosition;
        this.in = new RandomAccessFileInputStream(samFile, initialPosition);
        this.getNextLine();
    }

    public TextLineParser(InputStream in) throws IOException {
        this(in, 0L);
    }

    public TextLineParser(InputStream in, long initialPosition) throws IOException {
        if (in == null) {
            throw new NullPointerException("inputStream can not be null");
        }
        if (initialPosition < 0L) {
            throw new IllegalArgumentException("initial position must be >=0");
        }
        this.position = initialPosition;
        this.in = in;
        this.getNextLine();
    }

    private void getNextLine() throws IOException {
        int value;
        if (this.doneFile) {
            return;
        }
        GrowableCharArray builder = new GrowableCharArray(200);
        if (this.pushedBackValue == -2) {
            value = this.in.read();
        } else {
            value = this.pushedBackValue;
            this.pushedBackValue = -2;
        }
        this.numberOfBytesInNextLine = 0;
        while (true) {
            if (value == -1) {
                this.doneFile = true;
                this.close();
                break;
            }
            ++this.numberOfBytesInNextLine;
            builder.append((char)value);
            if (value == 13) {
                int nextChar = this.in.read();
                if (nextChar == 10) {
                    ++this.numberOfBytesInNextLine;
                    builder.append('\n');
                    break;
                }
                if (nextChar == -1) break;
                this.pushedBackValue = nextChar;
                break;
            }
            if (value == 10) break;
            value = this.in.read();
        }
        if (builder.getCurrentLength() > 0) {
            this.nextQueue.add(builder.createNewString());
        }
        if (this.doneFile) {
            this.nextQueue.add(this.endOfFile);
        }
    }

    @Override
    public long getPosition() {
        return this.position;
    }

    @Override
    public boolean hasNextLine() {
        Object next = this.nextQueue.peek();
        return next != this.endOfFile;
    }

    @Override
    public String peekLine() {
        Object next = this.nextQueue.peek();
        if (next == this.endOfFile) {
            return null;
        }
        return (String)next;
    }

    @Override
    public String nextLine() throws IOException {
        Object next = this.nextQueue.poll();
        if (next == this.endOfFile) {
            return null;
        }
        this.position += (long)this.numberOfBytesInNextLine;
        this.getNextLine();
        return (String)next;
    }

    @Override
    public void close() throws IOException {
        IOUtil.closeAndIgnoreErrors((Closeable)this.in);
        this.nextQueue.clear();
    }

    @Override
    public boolean tracksPosition() {
        return true;
    }
}

