/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.internal.core.io;

import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class StreamUtil {
    private StreamUtil() {
    }

    public static Runnable newOnCloseRunnableThatThrowsUncheckedIOExceptionIfNecessary(Closeable c) {
        return () -> {
            try {
                c.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
    }

    public static <T> Stream<T> newGeneratedStream(Supplier<Optional<T>> generatingFunction) {
        return StreamUtil.newGeneratedStream(generatingFunction, false);
    }

    public static <T> Stream<T> newGeneratedStream(final Supplier<Optional<T>> generatingFunction, boolean parallel) {
        Objects.requireNonNull(generatingFunction);
        Spliterators.AbstractSpliterator spliterator = new Spliterators.AbstractSpliterator<T>(Long.MAX_VALUE, 272){

            @Override
            public boolean tryAdvance(Consumer<? super T> action) {
                Optional r = (Optional)generatingFunction.get();
                if (!r.isPresent()) {
                    return false;
                }
                action.accept(r.get());
                return true;
            }
        };
        return StreamSupport.stream(spliterator, parallel);
    }
}

