/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.internal.core.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public final class RandomAccessFileInputStream
extends InputStream {
    private final RandomAccessFile randomAccessFile;
    private long bytesRead = 0L;
    private final Long length;
    private final boolean ownFile;

    public RandomAccessFileInputStream(File file, long startOffset) throws IOException {
        this.assertStartOffValid(file, startOffset);
        this.randomAccessFile = new RandomAccessFile(file, "r");
        this.randomAccessFile.seek(startOffset);
        this.length = null;
        this.ownFile = true;
    }

    public RandomAccessFileInputStream(File file, long startOffset, long length) throws IOException {
        this.assertStartOffValid(file, startOffset);
        this.randomAccessFile = new RandomAccessFile(file, "r");
        this.randomAccessFile.seek(startOffset);
        this.length = length;
        this.ownFile = true;
    }

    private void assertStartOffValid(File file, long startOffset) {
        if (startOffset < 0L) {
            throw new IllegalArgumentException("start offset can not be less than 0");
        }
        if (file.length() < startOffset) {
            throw new IllegalArgumentException(String.format("invalid startOffset %d: file is only %d bytes", startOffset, file.length()));
        }
    }

    public RandomAccessFileInputStream(RandomAccessFile file) {
        if (file == null) {
            throw new NullPointerException("file can not be null");
        }
        this.randomAccessFile = file;
        this.length = null;
        this.ownFile = false;
    }

    @Override
    public synchronized int read() throws IOException {
        if (this.length != null && this.bytesRead >= this.length) {
            return -1;
        }
        int value = this.randomAccessFile.read();
        if (value != -1) {
            ++this.bytesRead;
        }
        return value;
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        if (this.length != null && this.bytesRead >= this.length) {
            return -1;
        }
        int reducedLength = this.computeReducedLength(len);
        int numberOfBytesRead = this.randomAccessFile.read(b, off, reducedLength);
        this.bytesRead += (long)numberOfBytesRead;
        return numberOfBytesRead;
    }

    private int computeReducedLength(int len) {
        if (this.length == null) {
            return len;
        }
        return Math.min(len, (int)(this.length - this.bytesRead));
    }

    @Override
    public void close() throws IOException {
        if (this.ownFile) {
            this.randomAccessFile.close();
        }
    }
}

