/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.internal.core.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.io.InputStreamSupplier;
import org.jcvi.jillion.internal.core.io.LineParser;

public class PositionlessLineParser
implements LineParser {
    private final BufferedReader reader;
    private String nextLine;
    private boolean isClosed;

    public PositionlessLineParser(File inputFile) throws IOException {
        this(InputStreamSupplier.forFile(inputFile));
    }

    public PositionlessLineParser(InputStream in) throws IOException {
        this.reader = new BufferedReader(new InputStreamReader(in, IOUtil.UTF_8));
        this.updateNextLine();
    }

    public PositionlessLineParser(InputStreamSupplier inputStreamSupplier) throws IOException {
        this.reader = new BufferedReader(new InputStreamReader(inputStreamSupplier.get(), IOUtil.UTF_8));
        this.updateNextLine();
    }

    private void updateNextLine() throws IOException {
        this.nextLine = this.reader.readLine();
    }

    @Override
    public boolean hasNextLine() {
        return this.nextLine != null;
    }

    @Override
    public String peekLine() {
        return this.nextLine;
    }

    @Override
    public long getPosition() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean tracksPosition() {
        return false;
    }

    @Override
    public String nextLine() throws IOException {
        if (this.isClosed) {
            throw new IOException("closed");
        }
        String oldLine = this.nextLine;
        this.updateNextLine();
        return oldLine;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
        this.nextLine = null;
        this.isClosed = true;
    }
}

