/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.internal.core.io;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.jcvi.jillion.core.io.BufferSize;
import org.jcvi.jillion.core.io.FileUtil;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.io.OutputStreams;

public final class OutputStreamFactory {
    public static OutputStream create(File file) throws IOException {
        return OutputStreamFactory.create(file, BufferSize.kb(8));
    }

    public static OutputStream create(File file, int bufferSize) throws IOException {
        IOUtil.mkdirs(file.getParentFile());
        String extension = FileUtil.getExtension(file);
        if ("gz".equalsIgnoreCase(extension)) {
            return OutputStreams.gzip(file, bufferSize);
        }
        if ("zip".equalsIgnoreCase(extension)) {
            return OutputStreams.zip(file, bufferSize);
        }
        return new BufferedOutputStream(new FileOutputStream(file), bufferSize);
    }
}

