/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.internal.core.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;

public class OpenAwareInputStream
extends InputStream {
    private static final int EOF = -1;
    private final PushbackInputStream in;

    public OpenAwareInputStream(InputStream in) {
        if (in == null) {
            throw new NullPointerException("inputstream can not be null");
        }
        this.in = new PushbackInputStream(in);
    }

    @Override
    public int read() throws IOException {
        return this.in.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.in.read(b, off, len);
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.in.read(b);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.in.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.in.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.in.reset();
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    public boolean isOpen() {
        try {
            int value = this.in.read();
            if (value != -1) {
                this.in.unread(value);
                return true;
            }
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }
}

