/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.internal.core.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.jcvi.jillion.core.io.IOUtil;

public final class ByteBufferInputStream
extends InputStream {
    private final ByteBuffer buffer;

    public ByteBufferInputStream(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public synchronized int read() throws IOException {
        if (!this.buffer.hasRemaining()) {
            return -1;
        }
        return IOUtil.toUnsignedByte(this.buffer.get());
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        if (!this.buffer.hasRemaining()) {
            return -1;
        }
        int bytesRead = Math.min(len, this.buffer.remaining());
        this.buffer.get(b, off, bytesRead);
        return bytesRead;
    }
}

