/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.internal.core.datastore;

import java.io.Closeable;
import java.util.Iterator;
import org.jcvi.jillion.core.datastore.DataStore;
import org.jcvi.jillion.core.datastore.DataStoreClosedException;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.util.iter.IteratorUtil;
import org.jcvi.jillion.core.util.iter.StreamingIterator;

public final class DataStoreStreamingIterator<T>
implements StreamingIterator<T> {
    private final DataStore<?> parentDataStore;
    private final StreamingIterator<T> delegate;

    public static <T> DataStoreStreamingIterator<T> create(DataStore<?> parentDataStore, StreamingIterator<T> delegate) {
        return new DataStoreStreamingIterator<T>(parentDataStore, delegate);
    }

    public static <T> DataStoreStreamingIterator<T> create(DataStore<?> parentDataStore, Iterator<T> delegate) {
        return new DataStoreStreamingIterator<T>(parentDataStore, IteratorUtil.createStreamingIterator(delegate));
    }

    private DataStoreStreamingIterator(DataStore<?> parentDataStore, StreamingIterator<T> delegate) {
        this.parentDataStore = parentDataStore;
        this.delegate = delegate;
    }

    @Override
    public boolean hasNext() {
        boolean delegateHasNext = this.delegate.hasNext();
        if (this.parentDataStore.isClosed() && delegateHasNext) {
            IOUtil.closeAndIgnoreErrors((Closeable)this);
            throw new DataStoreClosedException("datastore is closed");
        }
        return delegateHasNext;
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public T next() {
        this.hasNext();
        return this.delegate.next();
    }

    @Override
    public void remove() {
        this.delegate.remove();
    }
}

