/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.internal.core.datastore;

import org.jcvi.jillion.core.datastore.DataStore;
import org.jcvi.jillion.core.datastore.DataStoreException;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.util.iter.StreamingIterator;

public final class DataStoreIterator<T>
implements StreamingIterator<T> {
    private StreamingIterator<String> ids;
    private final DataStore<T> dataStore;

    public DataStoreIterator(DataStore<T> dataStore) {
        this.dataStore = dataStore;
        try {
            this.ids = dataStore.idIterator();
        }
        catch (DataStoreException e) {
            IOUtil.closeAndIgnoreErrors(this.ids);
            throw new IllegalStateException("could not iterate over ids", e);
        }
    }

    @Override
    public boolean hasNext() {
        return this.ids.hasNext();
    }

    @Override
    public T next() {
        try {
            return this.dataStore.get(this.ids.next());
        }
        catch (DataStoreException e) {
            IOUtil.closeAndIgnoreErrors(this.ids);
            throw new IllegalStateException("could not get next element", e);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("can not remove");
    }

    @Override
    public void close() {
        this.ids.close();
    }
}

