/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.internal.core.datastore;

import java.io.IOException;
import org.jcvi.jillion.core.datastore.DataStore;
import org.jcvi.jillion.core.datastore.DataStoreClosedException;
import org.jcvi.jillion.core.datastore.DataStoreEntry;
import org.jcvi.jillion.core.datastore.DataStoreException;
import org.jcvi.jillion.core.util.iter.StreamingIterator;

public abstract class AbstractDataStore<T>
implements DataStore<T> {
    private volatile boolean isClosed;

    private final void throwExceptionIfClosed() {
        if (this.isClosed) {
            throw new DataStoreClosedException("DataStore is closed");
        }
    }

    protected abstract void handleClose() throws IOException;

    @Override
    public final synchronized void close() throws IOException {
        if (!this.isClosed) {
            this.handleClose();
        }
        this.isClosed = true;
    }

    @Override
    public final boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public final StreamingIterator<T> iterator() throws DataStoreException {
        this.throwExceptionIfClosed();
        return this.iteratorImpl();
    }

    @Override
    public final StreamingIterator<DataStoreEntry<T>> entryIterator() throws DataStoreException {
        this.throwExceptionIfClosed();
        return this.entryIteratorImpl();
    }

    protected abstract boolean containsImpl(String var1) throws DataStoreException;

    protected abstract T getImpl(String var1) throws DataStoreException;

    protected abstract long getNumberOfRecordsImpl() throws DataStoreException;

    protected abstract StreamingIterator<String> idIteratorImpl() throws DataStoreException;

    protected abstract StreamingIterator<T> iteratorImpl() throws DataStoreException;

    protected abstract StreamingIterator<DataStoreEntry<T>> entryIteratorImpl() throws DataStoreException;

    @Override
    public final boolean contains(String id) throws DataStoreException {
        if (id == null) {
            throw new NullPointerException("id can not be null");
        }
        this.throwExceptionIfClosed();
        return this.containsImpl(id);
    }

    @Override
    public final T get(String id) throws DataStoreException {
        if (id == null) {
            throw new NullPointerException("id can not be null");
        }
        this.throwExceptionIfClosed();
        return this.getImpl(id);
    }

    @Override
    public final StreamingIterator<String> idIterator() throws DataStoreException {
        this.throwExceptionIfClosed();
        return this.idIteratorImpl();
    }

    @Override
    public final long getNumberOfRecords() throws DataStoreException {
        this.throwExceptionIfClosed();
        return this.getNumberOfRecordsImpl();
    }
}

