/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.internal.core;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.Sequence;
import org.jcvi.jillion.internal.core.GlyphCodec;

public abstract class EncodedSequence<T>
implements Sequence<T> {
    private final GlyphCodec<T> codec;
    protected final byte[] data;
    private int hash;

    public EncodedSequence(GlyphCodec<T> codec, byte[] data) {
        this.codec = codec;
        this.data = Arrays.copyOf(data, data.length);
    }

    @Override
    public long getLength() {
        return this.codec.decodedLengthOf(this.data);
    }

    protected GlyphCodec<T> getCodec() {
        return this.codec;
    }

    @Override
    public int hashCode() {
        if (this.hash == 0 && this.getLength() > 0L) {
            int prime = 31;
            int result = 1;
            Iterator<T> iter = this.iterator();
            while (iter.hasNext()) {
                result = 31 * result + iter.next().hashCode();
            }
            this.hash = result;
        }
        return this.hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Sequence)) {
            return false;
        }
        Sequence other = (Sequence)obj;
        if (this.getLength() != other.getLength()) {
            return false;
        }
        Iterator<T> iter = this.iterator();
        Iterator otherIter = other.iterator();
        while (iter.hasNext()) {
            if (iter.next().equals(otherIter.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public T get(long index) {
        return this.codec.decode(this.data, index);
    }

    public String toString() {
        Iterator<T> iter = this.iterator();
        StringBuilder builder = new StringBuilder((int)this.getLength() * 5);
        while (iter.hasNext()) {
            if (builder.length() > 0) {
                builder.append(" ,");
            }
            builder.append(iter.next());
        }
        return builder.toString();
    }

    @Override
    public Iterator<T> iterator() {
        return new RangedIterator();
    }

    @Override
    public Iterator<T> iterator(Range range) {
        if (range == null) {
            return this.iterator();
        }
        return new RangedIterator(range);
    }

    private final class RangedIterator
    implements Iterator<T> {
        private int currentOffset;
        private final int stop;

        public RangedIterator() {
            this.currentOffset = 0;
            this.stop = (int)EncodedSequence.this.getLength();
        }

        public RangedIterator(Range r) {
            Range maxRange = new Range.Builder(EncodedSequence.this.getLength()).build();
            if (!r.isSubRangeOf(maxRange)) {
                throw new IndexOutOfBoundsException(String.format("range %s contains offsets that are out of bounds of %s", r, maxRange));
            }
            this.currentOffset = (int)r.getBegin();
            this.stop = (int)(r.getEnd() + 1L);
        }

        @Override
        public boolean hasNext() {
            return this.currentOffset < this.stop;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object next = EncodedSequence.this.get(this.currentOffset);
            ++this.currentOffset;
            return next;
        }
    }
}

