/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.internal.assembly.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.jcvi.jillion.assembly.util.Slice;
import org.jcvi.jillion.assembly.util.SliceBuilder;
import org.jcvi.jillion.assembly.util.SliceElement;
import org.jcvi.jillion.core.residue.nt.Nucleotide;
import org.jcvi.jillion.internal.assembly.util.CompactedSliceElement;

public class NoConsensusCompactedSlice
implements Slice {
    private final short[] elements;
    private final String[] ids;
    public static final NoConsensusCompactedSlice EMPTY = (NoConsensusCompactedSlice)new SliceBuilder().build();

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="only used internally by builders so don't have to worry about leaking ref")
    public NoConsensusCompactedSlice(short[] elements, List<String> ids) {
        this.elements = elements;
        this.ids = ids.toArray(new String[ids.size()]);
    }

    @Override
    public Iterator<SliceElement> iterator() {
        return new Iterator<SliceElement>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < NoConsensusCompactedSlice.this.ids.length;
            }

            @Override
            public SliceElement next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return NoConsensusCompactedSlice.this.getElement(this.i++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Map<Nucleotide, Integer> getNucleotideCounts() {
        int[] counts = new int[Nucleotide.getDnaValues().size()];
        for (int i = 0; i < this.elements.length; ++i) {
            int ordinal;
            int n = ordinal = this.elements[i] >>> 8 & 0xF;
            counts[n] = counts[n] + 1;
        }
        EnumMap<Nucleotide, Integer> map = new EnumMap<Nucleotide, Integer>(Nucleotide.class);
        for (int i = 0; i < counts.length; ++i) {
            int count = counts[i];
            map.put(Nucleotide.getDnaValues().get(i), count);
        }
        return map;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + NoConsensusCompactedSlice.sum(this.elements);
        result = 31 * result + new HashSet<String>(Arrays.asList(this.ids)).hashCode();
        return result;
    }

    private static int sum(short[] s) {
        int sum = 0;
        for (int i = 0; i < s.length; ++i) {
            sum += s[i];
        }
        return sum;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Slice)) {
            return false;
        }
        Slice other = (Slice)obj;
        if (this.getCoverageDepth() != other.getCoverageDepth()) {
            return false;
        }
        Nucleotide consensusCall = this.getConsensusCall();
        Nucleotide otherConsensusCall = other.getConsensusCall();
        if (consensusCall == null ? otherConsensusCall != null : !consensusCall.equals(otherConsensusCall)) {
            return false;
        }
        for (SliceElement element : other) {
            if (element.equals(this.getSliceElement(element.getId()))) continue;
            return false;
        }
        return true;
    }

    private CompactedSliceElement getElement(int i) {
        String id = this.ids[i];
        return CompactedSliceElement.create(id, this.elements[i]);
    }

    @Override
    public int getCoverageDepth() {
        return this.ids.length;
    }

    @Override
    public boolean containsElement(String elementId) {
        return this.indexOf(elementId) >= 0;
    }

    private int indexOf(String id) {
        if (id == null) {
            for (int i = 0; i < this.ids.length; ++i) {
                if (this.ids[i] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this.ids.length; ++i) {
                if (!id.equals(this.ids[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("consensus = ").append(this.getConsensusCall()).append(" ");
        for (SliceElement element : this) {
            builder.append(element).append(" | ");
        }
        return builder.toString();
    }

    @Override
    public SliceElement getSliceElement(String elementId) {
        int index = this.indexOf(elementId);
        if (index < 0) {
            return null;
        }
        return this.getElement(index);
    }

    @Override
    public Nucleotide getConsensusCall() {
        return null;
    }
}

