/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.internal.assembly.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import java.util.Iterator;
import org.jcvi.jillion.assembly.AssembledRead;
import org.jcvi.jillion.assembly.Contig;
import org.jcvi.jillion.assembly.util.GapQualityValueStrategy;
import org.jcvi.jillion.assembly.util.Slice;
import org.jcvi.jillion.assembly.util.SliceBuilder;
import org.jcvi.jillion.assembly.util.SliceMap;
import org.jcvi.jillion.core.Direction;
import org.jcvi.jillion.core.datastore.DataStoreException;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.qual.PhredQuality;
import org.jcvi.jillion.core.qual.QualitySequence;
import org.jcvi.jillion.core.qual.QualitySequenceDataStore;
import org.jcvi.jillion.core.residue.nt.Nucleotide;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.util.ThrowingStream;
import org.jcvi.jillion.core.util.iter.ArrayIterator;
import org.jcvi.jillion.core.util.iter.StreamingIterator;

public final class CompactedSliceMap
implements SliceMap {
    private static final PhredQuality DEFAULT_QUALITY = PhredQuality.valueOf(30);
    private final Slice[] slices;

    public static <PR extends AssembledRead> CompactedSliceMap create(Contig<PR> contig, QualitySequenceDataStore qualityDataStore, GapQualityValueStrategy qualityValueStrategy) throws DataStoreException {
        return new CompactedSliceMap(contig, qualityDataStore, qualityValueStrategy, DEFAULT_QUALITY);
    }

    public static <PR extends AssembledRead> CompactedSliceMap create(StreamingIterator<PR> iter, NucleotideSequence consensusSequence, QualitySequenceDataStore qualityDataStore, GapQualityValueStrategy qualityValueStrategy) throws DataStoreException {
        return new CompactedSliceMap(iter, consensusSequence, qualityDataStore, qualityValueStrategy, DEFAULT_QUALITY);
    }

    public static <PR extends AssembledRead> CompactedSliceMap create(StreamingIterator<PR> iter, NucleotideSequence consensusSequence, PhredQuality defaultQuality, GapQualityValueStrategy qualityValueStrategy) throws DataStoreException {
        return new CompactedSliceMap(iter, consensusSequence, null, qualityValueStrategy, defaultQuality);
    }

    private <PR extends AssembledRead, C extends Contig<PR>> CompactedSliceMap(C contig, QualitySequenceDataStore qualityDataStore, GapQualityValueStrategy qualityValueStrategy, PhredQuality defaultQuality) throws DataStoreException {
        this(contig.getReadIterator(), contig.getConsensusSequence(), qualityDataStore, qualityValueStrategy, defaultQuality);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <PR extends AssembledRead, C extends Contig<PR>> CompactedSliceMap(StreamingIterator<PR> readIter, NucleotideSequence consensusSequence, QualitySequenceDataStore qualityDataStore, GapQualityValueStrategy qualityValueStrategy, PhredQuality defaultQuality) throws DataStoreException {
        SliceBuilder[] builders = this.initializeSliceBuilders(consensusSequence);
        Iterator<PhredQuality> defaultIterator = qualityDataStore == null ? this.createNewDefaultQualityIterator(defaultQuality) : null;
        try (ThrowingStream<PR> readStream = readIter.toThrowingStream();){
            readStream.parallel().throwingForEach(read -> {
                int start = (int)read.getGappedStartOffset();
                int i = 0;
                String id = read.getId();
                Direction dir = read.getDirection();
                Iterator validRangeGappedQualitiesIterator = null;
                if (qualityDataStore == null) {
                    validRangeGappedQualitiesIterator = defaultIterator;
                } else {
                    QualitySequence fullQualities = (QualitySequence)qualityDataStore.get(id);
                    if (fullQualities == null) {
                        throw new NullPointerException("could not get qualities for " + id);
                    }
                    validRangeGappedQualitiesIterator = qualityValueStrategy.getGappedValidRangeQualitySequenceFor((AssembledRead)read, fullQualities).iterator();
                }
                for (Nucleotide base : read.getNucleotideSequence()) {
                    SliceBuilder builder;
                    PhredQuality quality = (PhredQuality)validRangeGappedQualitiesIterator.next();
                    SliceBuilder sliceBuilder = builder = builders[start + i];
                    synchronized (sliceBuilder) {
                        builder.add(id, base, quality, dir);
                    }
                    ++i;
                }
            });
            this.slices = new Slice[builders.length];
            for (int i = 0; i < this.slices.length; ++i) {
                this.slices[i] = builders[i].build();
            }
        }
        finally {
            IOUtil.closeAndIgnoreErrors(readIter);
        }
    }

    private SliceBuilder[] initializeSliceBuilders(NucleotideSequence consensus) {
        SliceBuilder[] builders = new SliceBuilder[(int)consensus.getLength()];
        int i = 0;
        Iterator iter = consensus.iterator();
        while (iter.hasNext()) {
            builders[i++] = new SliceBuilder().setConsensus((Nucleotide)iter.next());
        }
        return builders;
    }

    private Iterator<PhredQuality> createNewDefaultQualityIterator(final PhredQuality defaultQuality) {
        return new Iterator<PhredQuality>(){

            @Override
            public boolean hasNext() {
                return true;
            }

            @Override
            @SuppressFBWarnings(value={"IT_NO_SUCH_ELEMENT"}, justification="only used for fake data will never have no such element exception")
            public PhredQuality next() {
                return defaultQuality;
            }

            @Override
            public void remove() {
            }
        };
    }

    @Override
    public Iterator<Slice> iterator() {
        return new ArrayIterator<Slice>(this.slices, false);
    }

    @Override
    public Slice getSlice(long offset) {
        return this.slices[(int)offset];
    }

    @Override
    public long getSize() {
        return this.slices.length;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.slices);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SliceMap)) {
            return false;
        }
        SliceMap other = (SliceMap)obj;
        Iterator<Slice> iter = this.iterator();
        Iterator otherIter = other.iterator();
        while (iter.hasNext()) {
            if (!otherIter.hasNext()) {
                return false;
            }
            if (iter.next().equals(otherIter.next())) continue;
            return false;
        }
        return !otherIter.hasNext();
    }
}

