/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.internal.assembly.util;

import org.jcvi.jillion.assembly.util.SliceElement;
import org.jcvi.jillion.core.Direction;
import org.jcvi.jillion.core.qual.PhredQuality;
import org.jcvi.jillion.core.residue.nt.Nucleotide;

public final class CompactedSliceElement
implements SliceElement {
    private final String id;
    private final byte quality;
    private final byte dirAndNucleotide;

    public static CompactedSliceElement create(String id, short encodedValues) {
        byte dirAndNuc = (byte)(encodedValues >>> 8 & 0xFF);
        byte qual = (byte)(encodedValues & 0xFF);
        return new CompactedSliceElement(id, qual, dirAndNuc);
    }

    private CompactedSliceElement(String id, byte quality, byte encodedDirAndNucleotide) {
        if (id == null) {
            throw new NullPointerException("fields can not be null");
        }
        this.id = id;
        this.quality = quality;
        this.dirAndNucleotide = encodedDirAndNucleotide;
    }

    public CompactedSliceElement(String id, Nucleotide base, PhredQuality quality, Direction direction) {
        if (id == null || base == null || quality == null || direction == null) {
            throw new NullPointerException("fields can not be null");
        }
        this.id = id;
        this.quality = quality.getQualityScore();
        this.dirAndNucleotide = direction == Direction.FORWARD ? base.getOrdinalAsByte() : (byte)(base.getOrdinalAsByte() | 0x80);
    }

    public byte getEncodedDirAndNucleotide() {
        return this.dirAndNucleotide;
    }

    public byte getEncodedQuality() {
        return this.quality;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Nucleotide getBase() {
        int ordinal = this.dirAndNucleotide & 0xF;
        return Nucleotide.getDnaValues().get(ordinal);
    }

    @Override
    public PhredQuality getQuality() {
        return PhredQuality.valueOf(this.quality);
    }

    @Override
    public Direction getDirection() {
        if (this.dirAndNucleotide < 0) {
            return Direction.REVERSE;
        }
        return Direction.FORWARD;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.dirAndNucleotide;
        result = 31 * result + this.id.hashCode();
        result = 31 * result + this.quality;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SliceElement)) {
            return false;
        }
        SliceElement other = (SliceElement)obj;
        if (!this.id.equals(other.getId())) {
            return false;
        }
        if (!this.getQuality().equals(other.getQuality())) {
            return false;
        }
        if (!this.getBase().equals(other.getBase())) {
            return false;
        }
        return this.getDirection().equals((Object)other.getDirection());
    }

    public String toString() {
        return "CompactedSliceElement [id=" + this.id + ", getBase()=" + this.getBase() + "qual = " + this.getQuality() + " ]";
    }
}

