/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.internal.assembly;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jcvi.jillion.assembly.AbstractContigBuilder;
import org.jcvi.jillion.assembly.AssembledRead;
import org.jcvi.jillion.assembly.AssembledReadBuilder;
import org.jcvi.jillion.assembly.Contig;
import org.jcvi.jillion.core.Direction;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequenceBuilder;
import org.jcvi.jillion.core.util.MapUtil;
import org.jcvi.jillion.core.util.ThrowingStream;
import org.jcvi.jillion.core.util.iter.IteratorUtil;
import org.jcvi.jillion.core.util.iter.StreamingIterator;
import org.jcvi.jillion.internal.assembly.DefaultAssembledRead;

public final class DefaultContig<T extends AssembledRead>
implements Contig<T> {
    private final NucleotideSequence consensus;
    private final String id;
    private final Map<String, T> mapById;

    public DefaultContig(String id, NucleotideSequence consensus, Set<T> assembledReads) {
        if (id == null) {
            throw new NullPointerException("id can not be null");
        }
        if (consensus == null) {
            throw new NullPointerException("consensus can not be null");
        }
        this.id = id;
        this.consensus = consensus;
        int capacity = MapUtil.computeMinHashMapSizeWithoutRehashing(assembledReads.size());
        this.mapById = new LinkedHashMap<String, T>(capacity);
        for (AssembledRead r : assembledReads) {
            this.mapById.put(r.getId(), r);
        }
    }

    public DefaultContig(String id, NucleotideSequence consensus, Map<String, T> assembledReads) {
        if (id == null) {
            throw new NullPointerException("id can not be null");
        }
        if (consensus == null) {
            throw new NullPointerException("consensus can not be null");
        }
        if (assembledReads == null) {
            throw new NullPointerException("assembled read map can not be null");
        }
        this.id = id;
        this.consensus = consensus;
        this.mapById = assembledReads;
    }

    @Override
    public NucleotideSequence getConsensusSequence() {
        return this.consensus;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public long getNumberOfReads() {
        return this.mapById.size();
    }

    @Override
    public T getRead(String id) {
        return (T)((AssembledRead)this.mapById.get(id));
    }

    @Override
    public StreamingIterator<T> getReadIterator() {
        return IteratorUtil.createStreamingIterator(this.mapById.values().iterator());
    }

    @Override
    public ThrowingStream<T> reads() {
        return ThrowingStream.asThrowingStream(this.mapById.values().stream());
    }

    @Override
    public boolean containsRead(String placedReadId) {
        return this.mapById.containsKey(placedReadId);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.consensus.hashCode();
        result = 31 * result + this.id.hashCode();
        result = 31 * result + this.mapById.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Contig)) {
            return false;
        }
        Contig other = (Contig)obj;
        if (!this.id.equals(other.getId())) {
            return false;
        }
        if (!this.consensus.equals(other.getConsensusSequence())) {
            return false;
        }
        if (this.getNumberOfReads() != other.getNumberOfReads()) {
            return false;
        }
        for (Map.Entry<String, T> entry : this.mapById.entrySet()) {
            String readId = entry.getKey();
            if (!other.containsRead(readId)) {
                return false;
            }
            if (((AssembledRead)entry.getValue()).equals(other.getRead(readId))) continue;
            return false;
        }
        return true;
    }

    public static final class Builder
    extends AbstractContigBuilder<AssembledRead, Contig<AssembledRead>> {
        public Builder(String id, String consensus) {
            this(id, new NucleotideSequenceBuilder(consensus).build());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <R extends AssembledRead, C extends Contig<R>> Builder(C copy) {
            this(copy.getId(), copy.getConsensusSequence());
            StreamingIterator<R> iter = null;
            try {
                iter = copy.getReadIterator();
                while (iter.hasNext()) {
                    AssembledRead read = (AssembledRead)iter.next();
                    this.addRead(read);
                }
            }
            finally {
                IOUtil.closeAndIgnoreErrors(iter);
            }
        }

        public Builder(String id, NucleotideSequence consensus) {
            super(id, consensus);
        }

        public Builder addRead(String id, int offset, String basecalls) {
            return this.addRead(id, offset, basecalls, Direction.FORWARD);
        }

        public Builder addRead(String id, int offset, String basecalls, Direction dir) {
            int numberOfGaps = this.computeNumberOfGapsIn(basecalls);
            int ungappedLength = basecalls.length() - numberOfGaps;
            return this.addRead(id, offset, Range.ofLength(ungappedLength), basecalls, dir, ungappedLength);
        }

        private int computeNumberOfGapsIn(String basecalls) {
            int count = 0;
            for (int i = 0; i < basecalls.length(); ++i) {
                if (basecalls.charAt(i) != '-') continue;
                ++count;
            }
            return count;
        }

        public Builder addRead(String id, int offset, Range validRange, String basecalls, Direction dir, int fullUngappedLength) {
            if (offset < 0) {
                throw new IllegalArgumentException("circular reads not supported");
            }
            super.addRead(id, offset, validRange, basecalls, dir, fullUngappedLength);
            return this;
        }

        @Override
        public DefaultContig<AssembledRead> build() {
            if (this.consensusCaller != null) {
                this.recallConsensusNow();
            }
            int capacity = MapUtil.computeMinHashMapSizeWithoutRehashing(this.numberOfReads());
            LinkedHashMap reads = new LinkedHashMap(capacity);
            NucleotideSequence consensus = this.getConsensusBuilder().build();
            for (AssembledReadBuilder builder : this.getAllAssembledReadBuilders()) {
                reads.put(builder.getId(), builder.build(consensus));
            }
            return new DefaultContig<AssembledRead>(this.getContigId(), consensus, reads);
        }

        @Override
        protected AssembledReadBuilder<AssembledRead> createPlacedReadBuilder(AssembledRead read) {
            return DefaultAssembledRead.createBuilder(read.getId(), read.getNucleotideSequence().toString(), (int)read.getGappedStartOffset(), read.getDirection(), read.getReadInfo().getValidRange(), read.getReadInfo().getUngappedFullLength());
        }

        @Override
        protected AssembledReadBuilder<AssembledRead> createPlacedReadBuilder(String id, int offset, Range validRange, String basecalls, Direction dir, int fullUngappedLength) {
            return DefaultAssembledRead.createBuilder(id, basecalls, offset, dir, validRange, fullUngappedLength);
        }
    }
}

