/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.internal.assembly;

import java.util.Map;
import org.jcvi.jillion.assembly.AssembledRead;
import org.jcvi.jillion.assembly.AssembledReadBuilder;
import org.jcvi.jillion.assembly.AssemblyUtil;
import org.jcvi.jillion.assembly.ReadInfo;
import org.jcvi.jillion.core.Direction;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.residue.nt.Nucleotide;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequenceBuilder;
import org.jcvi.jillion.core.residue.nt.ReferenceMappedNucleotideSequence;

public final class DefaultAssembledRead
implements AssembledRead {
    private final long start;
    private final byte directionOrdinal;
    private final ReferenceMappedNucleotideSequence sequence;
    private final String id;
    private final ReadInfo readInfo;

    public static AssembledReadBuilder<AssembledRead> createBuilder(String readId, NucleotideSequence validBases, int offset, Direction dir, Range clearRange, int ungappedFullLength) {
        return new Builder(readId, validBases, offset, dir, clearRange, ungappedFullLength);
    }

    public static AssembledReadBuilder<AssembledRead> createBuilder(String readId, String validBases, int offset, Direction dir, Range clearRange, int ungappedFullLength) {
        return DefaultAssembledRead.createBuilder(readId, new NucleotideSequenceBuilder(validBases).build(), offset, dir, clearRange, ungappedFullLength);
    }

    public DefaultAssembledRead(String id, ReferenceMappedNucleotideSequence sequence, long start, Direction sequenceDirection, int ungappedFullLength, Range validRange) {
        this.id = id;
        this.sequence = sequence;
        this.start = start;
        this.directionOrdinal = (byte)sequenceDirection.ordinal();
        this.readInfo = new ReadInfo(validRange, ungappedFullLength);
    }

    @Override
    public ReadInfo getReadInfo() {
        return this.readInfo;
    }

    @Override
    public long getGappedLength() {
        return this.sequence.getLength();
    }

    @Override
    public long getGappedStartOffset() {
        return this.start;
    }

    public String toString() {
        return "DefaultPlacedRead [start=" + this.start + ", directionOrdinal=" + this.directionOrdinal + ", id=" + this.id + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id.hashCode();
        result = 31 * result + this.sequence.hashCode();
        result = 31 * result + this.directionOrdinal;
        result = 31 * result + (int)(this.start ^ this.start >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AssembledRead) {
            AssembledRead other = (AssembledRead)obj;
            if (this.getId() == null && other.getId() != null) {
                return false;
            }
            if (!this.getId().equals(other.getId())) {
                return false;
            }
            if (this.getNucleotideSequence() == null && other.getNucleotideSequence() != null) {
                return false;
            }
            if (other.getNucleotideSequence() == null) {
                return false;
            }
            if (!this.getNucleotideSequence().equals(other.getNucleotideSequence())) {
                return false;
            }
            return this.start == other.getGappedStartOffset() && this.getDirection() == other.getDirection();
        }
        return false;
    }

    @Override
    public Direction getDirection() {
        return Direction.values()[this.directionOrdinal];
    }

    @Override
    public long getGappedEndOffset() {
        return this.getGappedStartOffset() + this.getGappedLength() - 1L;
    }

    public Map<Integer, Nucleotide> getDifferenceMap() {
        return this.getNucleotideSequence().getDifferenceMap();
    }

    @Override
    public ReferenceMappedNucleotideSequence getNucleotideSequence() {
        return this.sequence;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public long toGappedValidRangeOffset(long referenceIndex) {
        long validRangeIndex = referenceIndex - this.getGappedStartOffset();
        this.checkValidRange(validRangeIndex);
        return validRangeIndex;
    }

    @Override
    public long toReferenceOffset(long validRangeIndex) {
        this.checkValidRange(validRangeIndex);
        return this.getGappedStartOffset() + validRangeIndex;
    }

    private void checkValidRange(long validRangeIndex) {
        if (validRangeIndex < 0L) {
            throw new IndexOutOfBoundsException("reference index refers to index before valid range " + validRangeIndex);
        }
        if (validRangeIndex > this.getGappedLength() - 1L) {
            throw new IndexOutOfBoundsException("reference index refers to index after valid range");
        }
    }

    @Override
    public Range asRange() {
        return this.getGappedContigRange();
    }

    @Override
    public Range getGappedContigRange() {
        return Range.of(this.getGappedStartOffset(), this.getGappedEndOffset());
    }

    protected static final class IllegalReAbacus
    extends IllegalArgumentException {
        private static final long serialVersionUID = -8272559886165301526L;

        public IllegalReAbacus(NucleotideSequence oldUngappedBasecalls, NucleotideSequence newUngappedBasecalls) {
            super(String.format("reAbacusing must retain same ungapped basecalls! '%s' vs '%s'", oldUngappedBasecalls, newUngappedBasecalls));
        }
    }

    private static class Builder
    implements AssembledReadBuilder<AssembledRead> {
        private final String readId;
        private NucleotideSequence originalSequence;
        private NucleotideSequenceBuilder basesBuilder = null;
        private int offset;
        private Range clearRange;
        private final Direction dir;
        private int ungappedFullLength;

        private Builder(Builder copy) {
            this.readId = copy.readId;
            this.dir = copy.dir;
            this.clearRange = copy.clearRange;
            this.offset = copy.offset;
            this.originalSequence = copy.originalSequence;
            this.basesBuilder = copy.basesBuilder == null ? null : copy.basesBuilder.copy();
            this.ungappedFullLength = copy.ungappedFullLength;
        }

        public Builder(String readId, NucleotideSequence validBases, int offset, Direction dir, Range clearRange, int ungappedFullLength) {
            if (readId == null) {
                throw new NullPointerException("read id can not be null");
            }
            if (dir == null) {
                throw new NullPointerException("direction can not be null");
            }
            if (validBases == null) {
                throw new NullPointerException("basecalls can not be null");
            }
            if (clearRange == null) {
                throw new NullPointerException("clearRange can not be null");
            }
            this.readId = readId;
            this.dir = dir;
            this.clearRange = clearRange;
            this.offset = offset;
            this.originalSequence = validBases;
            this.basesBuilder = null;
            if ((long)ungappedFullLength < clearRange.getEnd()) {
                throw new IllegalArgumentException("clear range extends beyond ungapped full length");
            }
            this.ungappedFullLength = ungappedFullLength;
        }

        @Override
        public AssembledReadBuilder<AssembledRead> copy() {
            return new Builder(this);
        }

        private void validateNewOffset(int newOffset) {
            if (newOffset < 0) {
                throw new IllegalArgumentException("read can not have negative offset");
            }
        }

        @Override
        public long getBegin() {
            return this.offset;
        }

        @Override
        public String getId() {
            return this.readId;
        }

        public Builder setStartOffset(int newOffset) {
            this.validateNewOffset(newOffset);
            this.offset = newOffset;
            return this;
        }

        public Builder shift(int numberOfBases) {
            return this.setStartOffset(this.offset + numberOfBases);
        }

        @Override
        public Range getClearRange() {
            return this.clearRange;
        }

        @Override
        public Direction getDirection() {
            return this.dir;
        }

        @Override
        public int getUngappedFullLength() {
            return this.ungappedFullLength;
        }

        @Override
        public synchronized AssembledRead build(NucleotideSequence reference) {
            if (reference == null) {
                throw new IllegalStateException("reference not set");
            }
            ReferenceMappedNucleotideSequence updatedEncodedBasecalls = this.createFinalBuilder().setReferenceHint(reference, this.offset).buildReferenceEncodedNucleotideSequence();
            return new DefaultAssembledRead(this.readId, updatedEncodedBasecalls, this.offset, this.dir, this.ungappedFullLength, this.clearRange);
        }

        protected NucleotideSequenceBuilder createFinalBuilder() {
            NucleotideSequenceBuilder finalBuilder = this.originalSequence == null ? this.basesBuilder : new NucleotideSequenceBuilder(this.originalSequence);
            return finalBuilder;
        }

        public synchronized Builder reAbacus(Range gappedValidRangeToChange, NucleotideSequence newBasecalls) {
            NucleotideSequence newUngappedBasecalls = new NucleotideSequenceBuilder(newBasecalls).ungap().build();
            NucleotideSequence oldUngappedBasecalls = this.getNucleotideSequenceBuilder().copy().trim(gappedValidRangeToChange).ungap().build();
            if (!oldUngappedBasecalls.equals(newUngappedBasecalls)) {
                throw new IllegalReAbacus(oldUngappedBasecalls, newUngappedBasecalls);
            }
            this.basesBuilder.delete(gappedValidRangeToChange);
            this.basesBuilder.insert((int)gappedValidRangeToChange.getBegin(), newBasecalls);
            return this;
        }

        @Override
        public synchronized long getLength() {
            if (this.basesBuilder != null) {
                return this.basesBuilder.getLength();
            }
            return this.originalSequence.getLength();
        }

        @Override
        public long getEnd() {
            return (long)this.offset + this.getLength() - 1L;
        }

        @Override
        public Range asRange() {
            return Range.of(this.offset, this.getEnd());
        }

        private synchronized NucleotideSequenceBuilder getNucleotideSequenceBuilder() {
            if (this.basesBuilder == null) {
                this.basesBuilder = new NucleotideSequenceBuilder(this.originalSequence);
                this.originalSequence = null;
            }
            return this.basesBuilder;
        }

        @Override
        public synchronized NucleotideSequence getCurrentNucleotideSequence() {
            if (this.originalSequence != null) {
                return this.originalSequence;
            }
            return this.basesBuilder.build();
        }

        public Builder append(Nucleotide base) {
            this.getNucleotideSequenceBuilder().append(base);
            if (base != Nucleotide.Gap) {
                this.expandValidRangeEnd(1L);
                ++this.ungappedFullLength;
            }
            return this;
        }

        public Builder append(Iterable<Nucleotide> sequence) {
            NucleotideSequenceBuilder validRangeBuilder = this.getNucleotideSequenceBuilder();
            long oldLength = validRangeBuilder.getUngappedLength();
            validRangeBuilder.append((Iterable)sequence);
            long newLength = validRangeBuilder.getUngappedLength();
            long numberUngappedBasesAdded = newLength - oldLength;
            this.expandValidRangeEnd(numberUngappedBasesAdded);
            this.ungappedFullLength = (int)((long)this.ungappedFullLength + numberUngappedBasesAdded);
            return this;
        }

        public Builder append(String sequence) {
            return this.append((Iterable)new NucleotideSequenceBuilder(sequence));
        }

        public Builder insert(int offset, String sequence) {
            return this.insert(offset, (Iterable)new NucleotideSequenceBuilder(sequence));
        }

        @Override
        public AssembledReadBuilder<AssembledRead> trim(Range trimRange) {
            NucleotideSequence untrimmed = this.getCurrentNucleotideSequence();
            int nonGapStart = AssemblyUtil.getRightFlankingNonGapIndex(untrimmed, (int)trimRange.getBegin());
            int nonGapEnd = AssemblyUtil.getLeftFlankingNonGapIndex(untrimmed, (int)trimRange.getEnd());
            int numLeft = untrimmed.getUngappedOffsetFor(nonGapStart);
            int numRight = (int)(untrimmed.getUngappedLength() - 1L - (long)untrimmed.getUngappedOffsetFor(nonGapEnd));
            this.getNucleotideSequenceBuilder().trim(trimRange);
            if (this.dir == Direction.FORWARD) {
                this.contractValidRangeBegin(numLeft);
                this.contractValidRangeEnd(numRight);
            } else {
                this.contractValidRangeBegin(numRight);
                this.contractValidRangeEnd(numLeft);
            }
            this.shift((int)trimRange.getBegin());
            return this;
        }

        public Builder replace(int offset, Nucleotide replacement) {
            NucleotideSequenceBuilder sequenceBuilder = this.getNucleotideSequenceBuilder();
            long oldLength = sequenceBuilder.getUngappedLength();
            sequenceBuilder.replace(offset, replacement);
            long newLength = sequenceBuilder.getUngappedLength();
            if (newLength < oldLength) {
                --this.ungappedFullLength;
                this.contractValidRangeEnd(1L);
            } else if (newLength > oldLength) {
                ++this.ungappedFullLength;
                this.expandValidRangeEnd(1L);
            }
            return this;
        }

        public Builder delete(Range range) {
            NucleotideSequenceBuilder sequenceBuilder = this.getNucleotideSequenceBuilder();
            long oldUngappedLength = sequenceBuilder.getUngappedLength();
            sequenceBuilder.delete(range);
            long newUngappedLength = sequenceBuilder.getUngappedLength();
            long numberOfUngappedBasesDeleted = oldUngappedLength - newUngappedLength;
            if (numberOfUngappedBasesDeleted > 0L) {
                this.contractValidRangeEnd(numberOfUngappedBasesDeleted);
                this.ungappedFullLength = (int)((long)this.ungappedFullLength - numberOfUngappedBasesDeleted);
            }
            return this;
        }

        @Override
        public int getNumGaps() {
            return this.getNucleotideSequenceBuilder().getNumGaps();
        }

        @Override
        public int getNumNs() {
            return this.getNucleotideSequenceBuilder().getNumNs();
        }

        @Override
        public int getNumAmbiguities() {
            return this.getNucleotideSequenceBuilder().getNumAmbiguities();
        }

        public Builder prepend(String sequence) {
            return this.prepend((Iterable)new NucleotideSequenceBuilder(sequence));
        }

        public Builder insert(int offset, Iterable<Nucleotide> sequence) {
            NucleotideSequenceBuilder validRangeBuilder = this.getNucleotideSequenceBuilder();
            long oldLength = validRangeBuilder.getUngappedLength();
            validRangeBuilder.insert(offset, (Iterable)sequence);
            long newLength = validRangeBuilder.getUngappedLength();
            long numberOfNonGapsAdded = newLength - oldLength;
            this.expandValidRangeEnd(numberOfNonGapsAdded);
            this.ungappedFullLength = (int)((long)this.ungappedFullLength + numberOfNonGapsAdded);
            return this;
        }

        public Builder insert(int offset, Nucleotide base) {
            NucleotideSequenceBuilder validRangeBuilder = this.getNucleotideSequenceBuilder();
            validRangeBuilder.insert(offset, base);
            if (base != Nucleotide.Gap) {
                this.expandValidRangeEnd(1L);
                ++this.ungappedFullLength;
            }
            return this;
        }

        public Builder prepend(Iterable<Nucleotide> sequence) {
            return this.insert(0, (Iterable)sequence);
        }

        private Builder expandValidRangeEnd(long units) {
            Range updatedClearRange;
            this.clearRange = updatedClearRange = new Range.Builder(this.clearRange).expandEnd(units).build();
            return this;
        }

        private Builder contractValidRangeBegin(long units) {
            Range updatedClearRange;
            this.clearRange = updatedClearRange = new Range.Builder(this.clearRange).contractBegin(units).build();
            return this;
        }

        private Builder contractValidRangeEnd(long units) {
            Range updatedClearRange;
            this.clearRange = updatedClearRange = new Range.Builder(this.clearRange).contractEnd(units).build();
            return this;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.readId.hashCode();
            result = 31 * result + this.dir.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Builder)) {
                return false;
            }
            Builder other = (Builder)obj;
            if (!this.readId.equals(other.readId)) {
                return false;
            }
            return this.dir.equals((Object)other.dir);
        }
    }
}

