/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.internal.align;

import org.jcvi.jillion.align.ProteinSequenceAlignment;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.residue.ResidueSequence;
import org.jcvi.jillion.core.residue.aa.AminoAcid;
import org.jcvi.jillion.core.residue.aa.ProteinSequence;
import org.jcvi.jillion.core.residue.aa.ProteinSequenceBuilder;
import org.jcvi.jillion.internal.align.AbstractSequenceAlignmentBuilder;

public class ProteinSequenceAlignmentBuilder
extends AbstractSequenceAlignmentBuilder<AminoAcid, ProteinSequence, ProteinSequenceBuilder, ProteinSequenceAlignment> {
    public ProteinSequenceAlignmentBuilder() {
    }

    public ProteinSequenceAlignmentBuilder(boolean builtFromTraceback) {
        super(builtFromTraceback);
    }

    public ProteinSequenceAlignmentBuilder(boolean builtFromTraceback, Integer subjectShiftAmount) {
        super(builtFromTraceback, subjectShiftAmount);
    }

    @Override
    protected ProteinSequenceBuilder createSequenceBuilder() {
        return new ProteinSequenceBuilder();
    }

    @Override
    protected ProteinSequenceAlignment createAlignment(double percentIdentity, int alignmentLength, int numMismatches, int numGap, ProteinSequence queryAlignment, ProteinSequence subjectAlignment, Range queryRange, Range subjectRange) {
        return new AminoAcidSequenceAlignmentImpl(percentIdentity, alignmentLength, numMismatches, numGap, queryAlignment, subjectAlignment, queryRange, subjectRange);
    }

    @Override
    protected Iterable<AminoAcid> parse(String sequence) {
        return new ProteinSequenceBuilder(sequence);
    }

    public ProteinSequenceAlignmentBuilder addMatches(String matchedSequence) {
        super.addMatches(matchedSequence);
        return this;
    }

    public ProteinSequenceAlignmentBuilder addMatch(AminoAcid match) {
        super.addMatch(match);
        return this;
    }

    public ProteinSequenceAlignmentBuilder addMatches(Iterable<AminoAcid> matches) {
        super.addMatches(matches);
        return this;
    }

    public ProteinSequenceAlignmentBuilder addMismatch(AminoAcid query, AminoAcid subject) {
        super.addMismatch(query, subject);
        return this;
    }

    public ProteinSequenceAlignmentBuilder addGap(AminoAcid query, AminoAcid subject) {
        super.addGap(query, subject);
        return this;
    }

    public ProteinSequenceAlignmentBuilder addGap(char query, char subject) {
        super.addGap(query, subject);
        return this;
    }

    @Override
    protected AminoAcid parse(char aa) {
        return AminoAcid.parse(Character.valueOf(aa));
    }

    private final class AminoAcidSequenceAlignmentImpl
    extends AbstractSequenceAlignmentBuilder.AbstractSequenceAlignmentImpl
    implements ProteinSequenceAlignment {
        public AminoAcidSequenceAlignmentImpl(double percentIdentity, int alignmentLength, int numMismatches, int numGap, ProteinSequence queryAlignment, ProteinSequence subjectAlignment, Range queryRange, Range subjectRange) {
            super((AbstractSequenceAlignmentBuilder)ProteinSequenceAlignmentBuilder.this, percentIdentity, alignmentLength, numMismatches, numGap, (ResidueSequence)queryAlignment, (ResidueSequence)subjectAlignment, queryRange, subjectRange);
        }
    }
}

