/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.internal.align;

import org.jcvi.jillion.align.NucleotideSequenceAlignment;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.residue.ResidueSequence;
import org.jcvi.jillion.core.residue.nt.Nucleotide;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequenceBuilder;
import org.jcvi.jillion.internal.align.AbstractSequenceAlignmentBuilder;

public class NucleotideSequenceAlignmentBuilder
extends AbstractSequenceAlignmentBuilder<Nucleotide, NucleotideSequence, NucleotideSequenceBuilder, NucleotideSequenceAlignment> {
    public NucleotideSequenceAlignmentBuilder() {
    }

    public NucleotideSequenceAlignmentBuilder(boolean builtFromTraceback) {
        super(builtFromTraceback);
    }

    public NucleotideSequenceAlignmentBuilder(boolean builtFromTraceback, Integer subjectShiftAmount) {
        super(builtFromTraceback, subjectShiftAmount);
    }

    @Override
    protected NucleotideSequenceBuilder createSequenceBuilder() {
        return new NucleotideSequenceBuilder();
    }

    @Override
    protected Nucleotide parse(char base) {
        return Nucleotide.parse(base);
    }

    public NucleotideSequenceAlignmentBuilder addMatch(Nucleotide match) {
        super.addMatch(match);
        return this;
    }

    public NucleotideSequenceAlignmentBuilder addMatches(Iterable<Nucleotide> matches) {
        super.addMatches(matches);
        return this;
    }

    public NucleotideSequenceAlignmentBuilder addMismatch(Nucleotide query, Nucleotide subject) {
        super.addMismatch(query, subject);
        return this;
    }

    public NucleotideSequenceAlignmentBuilder addGap(Nucleotide query, Nucleotide subject) {
        super.addGap(query, subject);
        return this;
    }

    @Override
    protected NucleotideSequenceAlignment createAlignment(double percentIdentity, int alignmentLength, int numMismatches, int numGap, NucleotideSequence queryAlignment, NucleotideSequence subjectAlignment, Range queryRange, Range subjectRange) {
        return new NucleotideSequenceAlignmentImpl(percentIdentity, alignmentLength, numMismatches, numGap, queryAlignment, subjectAlignment, queryRange, subjectRange);
    }

    @Override
    protected Iterable<Nucleotide> parse(String sequence) {
        return new NucleotideSequenceBuilder(sequence).build();
    }

    private final class NucleotideSequenceAlignmentImpl
    extends AbstractSequenceAlignmentBuilder.AbstractSequenceAlignmentImpl
    implements NucleotideSequenceAlignment {
        public NucleotideSequenceAlignmentImpl(double percentIdentity, int alignmentLength, int numMismatches, int numGap, NucleotideSequence queryAlignment, NucleotideSequence subjectAlignment, Range queryRange, Range subjectRange) {
            super((AbstractSequenceAlignmentBuilder)NucleotideSequenceAlignmentBuilder.this, percentIdentity, alignmentLength, numMismatches, numGap, (ResidueSequence)queryAlignment, (ResidueSequence)subjectAlignment, queryRange, subjectRange);
        }
    }
}

