/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.internal.align;

import java.util.Iterator;
import org.jcvi.jillion.align.SequenceAlignment;
import org.jcvi.jillion.core.DirectedRange;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.residue.Residue;
import org.jcvi.jillion.core.residue.ResidueSequence;
import org.jcvi.jillion.core.residue.ResidueSequenceBuilder;
import org.jcvi.jillion.internal.align.SequenceAlignmentBuilder;

public abstract class AbstractSequenceAlignmentBuilder<R extends Residue, S extends ResidueSequence<R, S, B>, B extends ResidueSequenceBuilder<R, S>, A extends SequenceAlignment<R, S>>
implements SequenceAlignmentBuilder<R, S, B, A> {
    private final B querySequenceBuilder = this.createSequenceBuilder();
    private final B subjectSequenceBuilder = this.createSequenceBuilder();
    private int numMatches = 0;
    private int numMisMatches = 0;
    private int alignmentLength = 0;
    private int numGaps = 0;
    private Integer queryStart;
    private Integer subjectStart;
    private final boolean builtFromTraceback;
    private Integer subjectShiftAmount;

    public AbstractSequenceAlignmentBuilder(boolean builtFromTraceback) {
        this(builtFromTraceback, null);
    }

    public AbstractSequenceAlignmentBuilder(boolean builtFromTraceback, Integer subjectShiftAmount) {
        this.builtFromTraceback = builtFromTraceback;
        this.subjectShiftAmount = null;
        this.subjectShiftAmount = subjectShiftAmount;
    }

    public AbstractSequenceAlignmentBuilder() {
        this(false);
    }

    protected abstract B createSequenceBuilder();

    protected abstract A createAlignment(double var1, int var3, int var4, int var5, S var6, S var7, Range var8, Range var9);

    protected abstract Iterable<R> parse(String var1);

    protected abstract R parse(char var1);

    @Override
    public SequenceAlignmentBuilder<R, S, B, A> setAlignmentOffsets(int queryOffset, int subjectOffset) {
        this.queryStart = queryOffset;
        this.subjectStart = subjectOffset;
        return this;
    }

    @Override
    public SequenceAlignmentBuilder<R, S, B, A> addMatches(String matchedSequence) {
        return this.addMatches(this.parse(matchedSequence));
    }

    @Override
    public SequenceAlignmentBuilder<R, S, B, A> addMismatches(String query, String subject) {
        if (query.length() != subject.length()) {
            throw new IllegalArgumentException(String.format("query and subject have different number of residues: %d vs %d", query.length(), subject.length()));
        }
        Iterator<R> queryBases = this.parse(query).iterator();
        Iterator<R> subjectBases = this.parse(subject).iterator();
        while (queryBases.hasNext()) {
            Residue nextQuery = (Residue)queryBases.next();
            Residue nextSubject = (Residue)subjectBases.next();
            this.addMismatch(nextQuery, nextSubject);
        }
        return this;
    }

    @Override
    public A build() {
        Range subjectRange;
        Range queryRange;
        double percentIdentity = this.alignmentLength == 0 ? 0.0 : (double)this.numMatches / (double)this.alignmentLength;
        if (this.queryStart == null) {
            this.queryStart = 0;
        }
        if (this.subjectStart == null) {
            this.subjectStart = 0;
        }
        long shiftedSubjectStart = this.subjectStart.intValue();
        if (this.subjectShiftAmount != null) {
            shiftedSubjectStart += (long)this.subjectShiftAmount.intValue();
        }
        if (this.builtFromTraceback) {
            queryRange = Range.of((long)this.queryStart.intValue() - this.querySequenceBuilder.getUngappedLength() + 1L, (long)this.queryStart.intValue());
            subjectRange = Range.of(shiftedSubjectStart - this.subjectSequenceBuilder.getUngappedLength() + 1L, shiftedSubjectStart);
            this.querySequenceBuilder.reverse();
            this.subjectSequenceBuilder.reverse();
        } else {
            queryRange = new Range.Builder(this.querySequenceBuilder.getUngappedLength()).shift(this.queryStart.intValue()).build();
            subjectRange = new Range.Builder(this.subjectSequenceBuilder.getUngappedLength()).shift(shiftedSubjectStart).build();
        }
        return this.createAlignment(percentIdentity, this.alignmentLength, this.numMisMatches, this.numGaps, (ResidueSequence)this.querySequenceBuilder.build(), (ResidueSequence)this.subjectSequenceBuilder.build(), queryRange, subjectRange);
    }

    @Override
    public SequenceAlignmentBuilder<R, S, B, A> addMatch(R match) {
        ++this.numMatches;
        return this.appendToBuilders(match, match);
    }

    @Override
    public SequenceAlignmentBuilder<R, S, B, A> addMatches(Iterable<R> matches) {
        for (Residue match : matches) {
            this.addMatch(match);
        }
        return this;
    }

    @Override
    public SequenceAlignmentBuilder<R, S, B, A> addMismatch(R query, R subject) {
        ++this.numMisMatches;
        this.appendToBuilders(query, subject);
        return this;
    }

    private SequenceAlignmentBuilder<R, S, B, A> appendToBuilders(R query, R subject) {
        this.querySequenceBuilder.append(query);
        this.subjectSequenceBuilder.append(subject);
        ++this.alignmentLength;
        return this;
    }

    @Override
    public SequenceAlignmentBuilder<R, S, B, A> addGap(char query, char subject) {
        return this.addGap(this.parse(query), this.parse(subject));
    }

    @Override
    public SequenceAlignmentBuilder<R, S, B, A> addGap(R query, R subject) {
        ++this.numGaps;
        return this.appendToBuilders(query, subject);
    }

    protected abstract class AbstractSequenceAlignmentImpl
    implements SequenceAlignment<R, S> {
        private final double percentIdentity;
        private final int alignmentLength;
        private final int numMismatches;
        private final int numGap;
        private final S queryAlignment;
        private final S subjectAlignment;
        private final DirectedRange queryRange;
        private final DirectedRange subjectRange;
        final /* synthetic */ AbstractSequenceAlignmentBuilder this$0;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        public AbstractSequenceAlignmentImpl(double alignmentLength, int numGap, int queryAlignment, int subjectAlignment, S queryRange, S subjectRange, Range range, Range range2) {
            void numMismatches;
            void percentIdentity;
            this.this$0 = (AbstractSequenceAlignmentBuilder)this$0;
            this.percentIdentity = percentIdentity;
            this.alignmentLength = (int)alignmentLength;
            this.numMismatches = numMismatches;
            this.numGap = numGap;
            this.queryAlignment = queryAlignment;
            this.subjectAlignment = subjectAlignment;
            this.queryRange = DirectedRange.create(queryRange);
            this.subjectRange = DirectedRange.create(subjectRange);
        }

        @Override
        public DirectedRange getQueryRange() {
            return this.queryRange;
        }

        @Override
        public DirectedRange getSubjectRange() {
            return this.subjectRange;
        }

        @Override
        public double getPercentIdentity() {
            return this.percentIdentity;
        }

        @Override
        public int getAlignmentLength() {
            return this.alignmentLength;
        }

        @Override
        public int getNumberOfMismatches() {
            return this.numMismatches;
        }

        @Override
        public int getNumberOfGapOpenings() {
            return this.numGap;
        }

        @Override
        public S getGappedQueryAlignment() {
            return this.queryAlignment;
        }

        @Override
        public S getGappedSubjectAlignment() {
            return this.subjectAlignment;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.alignmentLength;
            result = 31 * result + this.numGap;
            result = 31 * result + this.numMismatches;
            long temp = Double.doubleToLongBits(this.percentIdentity);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            result = 31 * result + (this.queryAlignment == null ? 0 : this.queryAlignment.hashCode());
            result = 31 * result + (this.queryRange == null ? 0 : this.queryRange.hashCode());
            result = 31 * result + (this.subjectAlignment == null ? 0 : this.subjectAlignment.hashCode());
            result = 31 * result + (this.subjectRange == null ? 0 : this.subjectRange.hashCode());
            return result;
        }

        public String toString() {
            return "AbstractSequenceAlignmentImpl [percentIdentity=" + this.percentIdentity + ", alignmentLength=" + this.alignmentLength + ", numMismatches=" + this.numMismatches + ", numGap=" + this.numGap + ", queryAlignment=" + this.queryAlignment + ", subjectAlignment=" + this.subjectAlignment + ", queryRange=" + this.queryRange + ", subjectRange=" + this.subjectRange + "]";
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof AbstractSequenceAlignmentImpl)) {
                return false;
            }
            AbstractSequenceAlignmentImpl other = (AbstractSequenceAlignmentImpl)obj;
            if (this.alignmentLength != other.alignmentLength) {
                return false;
            }
            if (this.numGap != other.numGap) {
                return false;
            }
            if (this.numMismatches != other.numMismatches) {
                return false;
            }
            if (Double.doubleToLongBits(this.percentIdentity) != Double.doubleToLongBits(other.percentIdentity)) {
                return false;
            }
            if (this.queryAlignment == null ? other.queryAlignment != null : !this.queryAlignment.equals(other.queryAlignment)) {
                return false;
            }
            if (this.queryRange == null ? other.queryRange != null : !this.queryRange.equals(other.queryRange)) {
                return false;
            }
            if (this.subjectAlignment == null ? other.subjectAlignment != null : !this.subjectAlignment.equals(other.subjectAlignment)) {
                return false;
            }
            return !(this.subjectRange == null ? other.subjectRange != null : !this.subjectRange.equals(other.subjectRange));
        }
    }
}

