/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;

public class ResourceHelper {
    private final Class<?> clazz;

    public ResourceHelper(Class<?> clazz) {
        this.clazz = clazz;
    }

    public ResourceHelper(Object classInstance) {
        this(classInstance.getClass());
    }

    public File getFile(String relativePath) throws IOException {
        URL url = this.clazz.getResource(relativePath);
        if (url == null) {
            return null;
        }
        return new File(this.urlDecode(url.getFile()));
    }

    public InputStream getFileAsStream(String relativePath) {
        return this.clazz.getResourceAsStream(relativePath);
    }

    private String urlDecode(String path) throws UnsupportedEncodingException {
        return URLDecoder.decode(path, "UTF-8");
    }

    public File getRootDir() {
        return new File(this.clazz.getName().replaceAll("\\.", "/")).getParentFile();
    }
}

