/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.fasta.qual;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jcvi.jillion.core.qual.PhredQuality;
import org.jcvi.jillion.core.qual.QualitySequence;
import org.jcvi.jillion.core.qual.QualitySequenceBuilder;
import org.jcvi.jillion.fasta.qual.CommentedQualityFastaRecord;
import org.jcvi.jillion.fasta.qual.QualityFastaRecord;
import org.jcvi.jillion.fasta.qual.UncommentedQualityFastaRecord;
import org.jcvi.jillion.shared.fasta.AbstractFastaRecordBuilder;

public final class QualityFastaRecordBuilder
extends AbstractFastaRecordBuilder<PhredQuality, QualitySequence, QualityFastaRecord, QualityFastaRecordBuilder> {
    private static final Pattern QUAL_BODY_PATTERN = Pattern.compile("\\d+");

    public QualityFastaRecordBuilder(String id, String entireRecordBody) {
        this(id, QualityFastaRecordBuilder.parseQualitySequence(entireRecordBody));
    }

    private static QualitySequence parseQualitySequence(String sequence) {
        QualitySequenceBuilder builder = new QualitySequenceBuilder(sequence.length());
        Matcher m = QUAL_BODY_PATTERN.matcher(sequence);
        while (m.find()) {
            builder.append(Byte.parseByte(m.group()));
        }
        return builder.build();
    }

    public QualityFastaRecordBuilder(String id, QualitySequence sequence) {
        super(id, sequence);
    }

    @Override
    protected QualityFastaRecord createNewInstance(String id, QualitySequence sequence, String comment) {
        if (comment == null) {
            return new UncommentedQualityFastaRecord(id, sequence);
        }
        return new CommentedQualityFastaRecord(id, sequence, comment);
    }

    @Override
    protected QualityFastaRecordBuilder getThis() {
        return this;
    }

    @Override
    protected QualityFastaRecordBuilder newBuilder(String id, QualitySequence seq, String comment) {
        return (QualityFastaRecordBuilder)new QualityFastaRecordBuilder(id, seq).comment(comment);
    }
}

