/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.fasta.qual;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Predicate;
import org.jcvi.jillion.core.datastore.DataStoreProviderHint;
import org.jcvi.jillion.core.io.InputStreamSupplier;
import org.jcvi.jillion.core.qual.PhredQuality;
import org.jcvi.jillion.core.qual.QualitySequence;
import org.jcvi.jillion.core.qual.QualitySequenceDataStore;
import org.jcvi.jillion.fasta.FastaParser;
import org.jcvi.jillion.fasta.qual.DefaultQualityFastaFileDataStore;
import org.jcvi.jillion.fasta.qual.QualityFastaDataStore;
import org.jcvi.jillion.fasta.qual.QualityFastaRecord;
import org.jcvi.jillion.internal.fasta.qual.IndexedQualityFastaFileDataStore;
import org.jcvi.jillion.internal.fasta.qual.LargeQualityFastaFileDataStore;
import org.jcvi.jillion.shared.fasta.AbstractFastaFileDataStoreBuilder;

public final class QualityFastaFileDataStoreBuilder
extends AbstractFastaFileDataStoreBuilder<PhredQuality, QualitySequence, QualityFastaRecord, QualitySequenceDataStore, QualityFastaDataStore> {
    public QualityFastaFileDataStoreBuilder(File fastaFile) throws IOException {
        super(fastaFile);
    }

    public QualityFastaFileDataStoreBuilder(InputStream fastaFileAsStream) throws IOException {
        super(fastaFileAsStream);
    }

    public QualityFastaFileDataStoreBuilder(FastaParser parser) {
        super(parser);
    }

    public QualityFastaFileDataStoreBuilder(InputStreamSupplier supplier) throws IOException {
        super(supplier);
    }

    @Override
    protected QualityFastaDataStore createNewInstance(FastaParser parser, DataStoreProviderHint hint, Predicate<String> filter, Predicate<QualityFastaRecord> recordFilter) throws IOException {
        if (parser.isReadOnceOnly()) {
            return DefaultQualityFastaFileDataStore.create(parser, filter, recordFilter);
        }
        switch (hint) {
            case RANDOM_ACCESS_OPTIMIZE_SPEED: {
                return DefaultQualityFastaFileDataStore.create(parser, filter, recordFilter);
            }
            case RANDOM_ACCESS_OPTIMIZE_MEMORY: {
                return parser.canCreateMemento() ? IndexedQualityFastaFileDataStore.create(parser, filter, recordFilter) : DefaultQualityFastaFileDataStore.create(parser, filter, recordFilter);
            }
            case ITERATION_ONLY: {
                return LargeQualityFastaFileDataStore.create(parser, filter, recordFilter);
            }
        }
        throw new IllegalArgumentException("unknown hint : " + (Object)((Object)hint));
    }

    public QualityFastaFileDataStoreBuilder filter(Predicate<String> filter) {
        super.filter(filter);
        return this;
    }

    public QualityFastaFileDataStoreBuilder hint(DataStoreProviderHint hint) {
        super.hint(hint);
        return this;
    }

    public QualityFastaFileDataStoreBuilder filterRecords(Predicate<QualityFastaRecord> filter) {
        super.filterRecords(filter);
        return this;
    }

    @Override
    public QualityFastaDataStore build() throws IOException {
        return (QualityFastaDataStore)super.build();
    }
}

