/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.fasta.qual;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Predicate;
import org.jcvi.jillion.core.datastore.DataStoreFilters;
import org.jcvi.jillion.fasta.FastaFileParser;
import org.jcvi.jillion.fasta.FastaParser;
import org.jcvi.jillion.fasta.qual.QualityFastaDataStore;
import org.jcvi.jillion.fasta.qual.QualityFastaRecord;
import org.jcvi.jillion.internal.fasta.qual.DefaultQualityFastaFileDataStoreBuilder;

final class DefaultQualityFastaFileDataStore {
    private DefaultQualityFastaFileDataStore() {
    }

    public static QualityFastaDataStore create(File fastaFile) throws IOException {
        return DefaultQualityFastaFileDataStore.create(fastaFile, (Predicate<String>)DataStoreFilters.alwaysAccept(), null);
    }

    public static QualityFastaDataStore create(File fastaFile, Predicate<String> filter, Predicate<QualityFastaRecord> recordFilter) throws IOException {
        return DefaultQualityFastaFileDataStore.create(FastaFileParser.create(fastaFile), filter, recordFilter);
    }

    public static QualityFastaDataStore create(InputStream fastaStream) throws IOException {
        return DefaultQualityFastaFileDataStore.create(fastaStream, (Predicate<String>)DataStoreFilters.alwaysAccept(), null);
    }

    public static QualityFastaDataStore create(InputStream fastaStream, Predicate<String> filter, Predicate<QualityFastaRecord> recordFilter) throws IOException {
        FastaParser parser = FastaFileParser.create(fastaStream);
        return DefaultQualityFastaFileDataStore.create(parser, filter, recordFilter);
    }

    public static QualityFastaDataStore create(FastaParser parser, Predicate<String> filter, Predicate<QualityFastaRecord> recordFilter) throws IOException {
        DefaultQualityFastaFileDataStoreBuilder builder = DefaultQualityFastaFileDataStore.createBuilder(filter, recordFilter);
        parser.parse(builder);
        return builder.build();
    }

    private static DefaultQualityFastaFileDataStoreBuilder createBuilder(Predicate<String> filter, Predicate<QualityFastaRecord> recordFilter) {
        return new DefaultQualityFastaFileDataStoreBuilder(filter, recordFilter);
    }
}

