/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.fasta.pos;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Comparator;
import org.jcvi.jillion.core.pos.Position;
import org.jcvi.jillion.core.pos.PositionSequence;
import org.jcvi.jillion.core.util.iter.StreamingIterator;
import org.jcvi.jillion.fasta.FastaWriter;
import org.jcvi.jillion.fasta.pos.LargePositionFastaIterator;
import org.jcvi.jillion.fasta.pos.PositionFastaRecord;
import org.jcvi.jillion.fasta.pos.PositionFastaWriter;
import org.jcvi.jillion.internal.fasta.InMemorySortedFastaWriter;
import org.jcvi.jillion.internal.fasta.TmpDirSortedFastaWriter;
import org.jcvi.jillion.shared.fasta.AbstractFastaRecordWriter;

public final class PositionFastaWriterBuilder
extends AbstractFastaRecordWriter.AbstractBuilder<Position, PositionSequence, PositionFastaRecord, PositionFastaWriter, PositionFastaWriterBuilder> {
    public PositionFastaWriterBuilder(File outputFile) throws IOException {
        super(outputFile);
    }

    public PositionFastaWriterBuilder(OutputStream out) {
        super(out);
    }

    @Override
    protected PositionFastaWriterBuilder getThis() {
        return this;
    }

    @Override
    protected PositionFastaWriter create(OutputStream out, int numberOfResiduesPerLine, Charset charSet, String eol) {
        return new PositionSequenceFastaRecordWriterImpl(out, numberOfResiduesPerLine, charSet, eol);
    }

    @Override
    protected int getDefaultNumberOfSymbolsPerLine() {
        return 12;
    }

    @Override
    protected PositionFastaWriter createTmpDirSortedWriterWriter(FastaWriter<Position, PositionSequence, PositionFastaRecord> delegate, Comparator<PositionFastaRecord> comparator, int cacheSize, File tmpDir) {
        return new TmpDirSortedPositionFastaWriter(delegate, comparator, cacheSize, tmpDir);
    }

    @Override
    protected PositionFastaWriter createInMemorySortedWriterWriter(FastaWriter<Position, PositionSequence, PositionFastaRecord> delegate, Comparator<PositionFastaRecord> comparator) {
        return new InMemorySortedPositionFastaWriter(delegate, comparator);
    }

    private static final class TmpDirSortedPositionFastaWriter
    extends TmpDirSortedFastaWriter<Position, PositionSequence, PositionFastaRecord>
    implements PositionFastaWriter {
        public TmpDirSortedPositionFastaWriter(FastaWriter<Position, PositionSequence, PositionFastaRecord> finalWriter, Comparator<PositionFastaRecord> comparator, int cacheSize, File tmpDir) {
            super(finalWriter, comparator, tmpDir, cacheSize);
        }

        @Override
        protected StreamingIterator<PositionFastaRecord> createStreamingIteratorFor(File tmpFastaFile) throws IOException {
            return LargePositionFastaIterator.createNewIteratorFor(tmpFastaFile);
        }

        @Override
        protected FastaWriter<Position, PositionSequence, PositionFastaRecord> createNewTmpWriter(File tmpFile) throws IOException {
            return new PositionFastaWriterBuilder(tmpFile).build();
        }

        @Override
        protected PositionFastaRecord createFastaRecord(String id, PositionSequence sequence, String optionalComment) {
            return new PositionFastaRecord(id, optionalComment, sequence);
        }
    }

    private static final class InMemorySortedPositionFastaWriter
    extends InMemorySortedFastaWriter<Position, PositionSequence, PositionFastaRecord>
    implements PositionFastaWriter {
        public InMemorySortedPositionFastaWriter(FastaWriter<Position, PositionSequence, PositionFastaRecord> writer, Comparator<PositionFastaRecord> comparator) {
            super(writer, comparator);
        }

        @Override
        protected PositionFastaRecord createRecord(String id, PositionSequence sequence, String optionalComment) {
            return new PositionFastaRecord(id, optionalComment, sequence);
        }
    }

    private static final class PositionSequenceFastaRecordWriterImpl
    extends AbstractFastaRecordWriter<Position, PositionSequence, PositionFastaRecord>
    implements PositionFastaWriter {
        private PositionSequenceFastaRecordWriterImpl(OutputStream out, int numberOfResiduesPerLine, Charset charSet, String eol) {
            super(out, numberOfResiduesPerLine, charSet, eol);
        }

        @Override
        protected String getStringRepresentationFor(Position symbol) {
            return String.format("%04d", symbol.getValue());
        }

        @Override
        protected boolean hasSymbolSeparator() {
            return true;
        }

        @Override
        protected String getSymbolSeparator() {
            return " ";
        }
    }
}

